% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package.R
\docType{package}
\name{pkgcache-package}
\alias{pkgcache}
\alias{pkgcache-package}
\title{Cache for package data and metadata}
\description{
Metadata and package cache for CRAN-like repositories. This is a utility package to be used by package management tools that want to take advantage of caching.
}
\details{
Metadata and package cache for CRAN-like repositories. This is a utility
package to be used by package management tools that want to take
advantage of caching.
\subsection{Installation}{

You can install the released version of pkgcache from
\href{https://CRAN.R-project.org}{CRAN} with:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{install.packages("pkgcache")
}\if{html}{\out{</div>}}
}

\subsection{Metadata cache}{

\code{meta_cache_list()} lists all packages in the metadata cache. It
includes Bioconductor package, and all versions (i.e. both binary and
source) of the packages for the current platform and R version.

(We load the pillar package, because it makes the pkgcache data frames
print nicer, similarly to tibbles.)

\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(pkgcache)
library(pillar)
meta_cache_list()
#> # A data frame: 45,961 x 32
#>    package version depends sugge~1 license imports linki~2 archs enhan~3 licen~4
#>    <chr>   <chr>   <chr>   <chr>   <chr>   <chr>   <chr>   <chr> <chr>   <chr>  
#>  1 A3      1.0.0   R (>= ~ random~ GPL (>~ <NA>    <NA>    <NA>  <NA>    <NA>   
#>  2 AATtoo~ 0.0.2   R (>= ~ <NA>    GPL-3   magrit~ <NA>    <NA>  <NA>    <NA>   
#>  3 ABACUS  1.0.0   R (>= ~ rmarkd~ GPL-3   ggplot~ <NA>    <NA>  <NA>    <NA>   
#>  4 ABC.RAP 0.9.0   R (>= ~ knitr,~ GPL-3   graphi~ <NA>    <NA>  <NA>    <NA>   
#>  5 ABCana~ 1.2.1   R (>= ~ <NA>    GPL-3   plotrix <NA>    <NA>  <NA>    <NA>   
#>  6 ABCopt~ 0.15.0  <NA>    testth~ MIT + ~ Rcpp, ~ Rcpp    ABCo~ <NA>    <NA>   
#>  7 ABCp2   1.2     MASS    <NA>    GPL-2   <NA>    <NA>    <NA>  <NA>    <NA>   
#>  8 ABHgen~ 1.0.1   <NA>    knitr,~ GPL-3   ggplot~ <NA>    <NA>  <NA>    <NA>   
#>  9 ABPS    0.3     <NA>    testth~ GPL (>~ kernlab <NA>    <NA>  <NA>    <NA>   
#> 10 ABSurv~ 0.1.0   R (>= ~ <NA>    GPL-3   stats,~ <NA>    <NA>  <NA>    <NA>   
#> # ... with 45,951 more rows, 22 more variables: os_type <chr>, priority <chr>,
#> #   license_is_foss <chr>, repodir <chr>, rversion <chr>, platform <chr>,
#> #   needscompilation <chr>, ref <chr>, type <chr>, direct <lgl>, status <chr>,
#> #   target <chr>, mirror <chr>, sources <list>, filesize <int>, sha256 <chr>,
#> #   sysreqs <chr>, built <chr>, published <dttm>, deps <list>, md5sum <chr>,
#> #   path <chr>, and abbreviated variable names 1: suggests, 2: linkingto,
#> #   3: enhances, 4: license_restricts_use
}\if{html}{\out{</div>}}

\code{meta_cache_deps()} and \code{meta_cache_revdeps()} can be used to look up
dependencies and reverse dependencies.

The metadata is updated automatically if it is older than seven days,
and it can also be updated manually with \code{meta_cache_update()}.

See the \code{cranlike_metadata_cache} R6 class for a lower level API, and
more control.
}

\subsection{Package cache}{

Package management tools may use the \verb{pkg_cache_*} functions and in
particular the \code{package_cache} class, to make use of local caching of
package files.

The \verb{pkg_cache_*} API is high level, and uses a user level cache:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{pkg_cache_summary()
#> $cachepath
#> [1] "/Users/gaborcsardi/Library/Caches/org.R-project.R/R/pkgcache/pkg"
#> 
#> $files
#> [1] 321
#> 
#> $size
#> [1] 420283448
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{pkg_cache_list()
#> # A data frame: 321 x 11
#>    fullpath       path  package url   etag  sha256 version platf~1 built vigne~2
#>    <chr>          <chr> <chr>   <chr> <chr> <chr>  <chr>   <chr>   <int>   <int>
#>  1 /Users/gaborc~ src/~ tibble  http~ "\"a~ acf30~ 3.1.8   source     NA      NA
#>  2 /Users/gaborc~ bin/~ rmsfact http~ "\"4~ 44c34~ 0.0.3   aarch6~    NA      NA
#>  3 /Users/gaborc~ bin/~ fortun~ http~ "\"3~ 943db~ 1.5-4   aarch6~    NA      NA
#>  4 /Users/gaborc~ bin/~ cowsay  http~ "\"6~ 4d9c3~ 0.8.0   aarch6~    NA      NA
#>  5 /Users/gaborc~ bin/~ multic~ http~ "\"1~ 55859~ 0.1.5   aarch6~    NA      NA
#>  6 /Users/gaborc~ src/~ cli     <NA>   <NA> 8b0ce~ <NA>    <NA>        0      NA
#>  7 /Users/gaborc~ src/~ cli     <NA>   <NA> 8b0ce~ 3.5.0.~ source      1       0
#>  8 /Users/gaborc~ src/~ cli     <NA>   <NA> 8b0ce~ 3.5.0.~ aarch6~     1       0
#>  9 /Users/gaborc~ src/~ cli     <NA>   <NA> bc503~ <NA>    <NA>        0      NA
#> 10 /Users/gaborc~ src/~ cli     <NA>   <NA> bc503~ 3.5.0.~ source      1       0
#> # ... with 311 more rows, 1 more variable: rversion <chr>, and abbreviated
#> #   variable names 1: platform, 2: vignettes
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{pkg_cache_find(package = "dplyr")
#> # A data frame: 5 x 11
#>   fullp~1 path  package url   etag  sha256 version platf~2 built vigne~3 rvers~4
#>   <chr>   <chr> <chr>   <chr> <chr> <chr>  <chr>   <chr>   <int>   <int> <chr>  
#> 1 /Users~ bin/~ dplyr   http~ "\"6~ 162b5~ 1.0.10  aarch6~    NA      NA <NA>   
#> 2 /Users~ bin/~ dplyr   http~ "\"6~ 9014f~ 1.0.9   aarch6~    NA      NA <NA>   
#> 3 /Users~ src/~ dplyr   http~ "\"1~ 8cb05~ 1.1.0   source     NA      NA <NA>   
#> 4 /Users~ bin/~ dplyr   http~ "\"6~ 54679~ 1.1.0   aarch6~    NA      NA <NA>   
#> 5 /Users~ bin/~ dplyr   http~ "\"1~ 6ebb2~ 1.1.0   aarch6~    NA      NA <NA>   
#> # ... with abbreviated variable names 1: fullpath, 2: platform, 3: vignettes,
#> #   4: rversion
}\if{html}{\out{</div>}}

\code{pkg_cache_add_file()} can be used to add a file,
\code{pkg_cache_delete_files()} to remove files, \code{pkg_cache_get_files()} to
copy files out of the cache.

The \code{package_cache} class provides a finer API.
}

\subsection{Bioconductor support}{

Both the metadata cache and the package cache support Bioconductor by
default, automatically. See the \code{BioC_mirror} option and the
\code{R_BIOC_MIRROR} and \code{R_BIOC_VERSION} environment variables below to
configure Bioconductor support.
}

\subsection{Package Options}{
\itemize{
\item The \code{BioC_mirror} option can be used to select a Bioconductor mirror.
This takes priority over the \code{R_BIOC_MIRROR} environment variable.
\item \code{pkgcache_timeout} is the HTTP timeout for all downloads. It is in
seconds, and the limit for downloading the whole file. Defaults to
3600, one hour. It corresponds to the \href{https://curl.se/libcurl/c/CURLOPT_TIMEOUT.html}{\code{TIMEOUT} libcurl option}.
\item \code{pkgcache_connecttimeout} is the HTTP timeout for the connection
phase. It is in seconds and defaults to 30 seconds. It corresponds to
the \href{https://curl.se/libcurl/c/CURLOPT_CONNECTTIMEOUT.html}{\code{CONNECTTIMEOUT} libcurl option}.
\item \code{pkgcache_low_speed_limit} and \code{pkgcache_low_speed_time} are used for
a more sensible HTTP timeout. If the download speed is less than
\code{pkgcache_low_speed_limit} bytes per second for at least
\code{pkgcache_low_speed_time} seconds, the download errors. They
correspond to the
\href{https://curl.se/libcurl/c/CURLOPT_LOW_SPEED_LIMIT.html}{\code{LOW_SPEED_LIMIT}}
and
\href{https://curl.se/libcurl/c/CURLOPT_LOW_SPEED_TIME.html}{\code{LOW_SPEED_TIME}}
curl options.
}
}

\subsection{Package environment variables}{
\itemize{
\item The \code{R_BIOC_VERSION} environment variable can be used to override the
default Bioconductor version detection and force a given version. E.g.
this can be used to force the development version of Bioconductor.
\item The \code{R_BIOC_MIRROR} environment variable can be used to select a
Bioconductor mirror. The \code{BioC_mirror} option takes priority over
this, if set.
\item \code{PKGCACHE_PPM_REPO} is the name of the Posit Package Manager
repository to use. Defaults to \code{"cran"}.
\item \code{PKGCACHE_PPM_URL} is the base URL of the Posit Package Manager
instance to use. It defaults to the URL of the Posit Public Package
Manager instance at \url{https://packagemanager.posit.co/client/#/}.
\item \code{PKGCACHE_TIMEOUT} is the HTTP timeout for all downloads. It is in
seconds, and the limit for downloading the whole file. Defaults to
3600, one hour. It corresponds to the \href{https://curl.se/libcurl/c/CURLOPT_TIMEOUT.html}{\code{TIMEOUT} libcurl option}. The
\code{pkgcache_timeout} option has priority over this, if set.
\item \code{PKGCACHE_CONNECTTIMEOUT} is the HTTP timeout for the connection
phase. It is in seconds and defaults to 30 seconds. It corresponds to
the \href{https://curl.se/libcurl/c/CURLOPT_CONNECTTIMEOUT.html}{\code{CONNECTTIMEOUT} libcurl option}. The
\code{pkgcache_connecttimeout} option takes precedence over this, if set.
\item \code{PKGCACHE_LOW_SPEED_LIMIT} and \code{PKGCACHE_LOW_SPEED_TIME} are used for
a more sensible HTTP timeout. If the download speed is less than
\code{PKGCACHE_LOW_SPEED_LIMIT} bytes per second for at least
\code{PKGCACHE_LOW_SPEED_TIME} seconds, the download errors. They
correspond to the
\href{https://curl.se/libcurl/c/CURLOPT_LOW_SPEED_LIMIT.html}{\code{LOW_SPEED_LIMIT}}
and
\href{https://curl.se/libcurl/c/CURLOPT_LOW_SPEED_TIME.html}{\code{LOW_SPEED_TIME}}
curl options. The \code{pkgcache_low_speed_time} and
\code{pkgcache_low_speed_limit} options have priority over these
environment variables, if they are set.
\item \code{R_PKG_CACHE_DIR} is used for the cache directory, if set. (Otherwise
\code{rappdirs::user_cache_dir()} is used, see also \code{meta_cache_summary()}
and \code{pkg_cache_summary()}).
}
}

\subsection{Using pkgcache in CRAN packages}{

If you use pkgcache in your CRAN package, please make sure that
\itemize{
\item you don’t use pkgcache in your examples, and
\item you set the \code{R_USER_CACHE_DIR} environment variable to a temporary
directory (e.g. via \code{tempfile()}) during test cases. See the
\code{tests/testthat/setup.R} file in pkgcache for an example.
}

This is to make sure that pkgcache does not modify the user’s files
while running \verb{R CMD check}.
}

\subsection{Code of Conduct}{

Please note that the pkgcache project is released with a \href{https://r-lib.github.io/pkgcache/CODE_OF_CONDUCT.html}{Contributor Code of Conduct}.
By contributing to this project, you agree to abide by its terms.
}

\subsection{License}{

MIT (c) \href{https://posit.co}{Posit Software, PBC}
}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/r-lib/pkgcache#readme}
  \item \url{https://r-lib.github.io/pkgcache/}
  \item Report bugs at \url{https://github.com/r-lib/pkgcache/issues}
}

}
\author{
\strong{Maintainer}: Gábor Csárdi \email{csardi.gabor@gmail.com}

Other contributors:
\itemize{
  \item RStudio [copyright holder, funder]
}

}
