% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repo-status.R
\name{repo_status}
\alias{repo_status}
\title{Show the status of CRAN-like repositories}
\usage{
repo_status(
  platforms = default_platforms(),
  r_version = getRversion(),
  bioc = TRUE,
  cran_mirror = default_cran_mirror()
)
}
\arguments{
\item{platforms}{Platforms to use, default is \code{\link[=default_platforms]{default_platforms()}}.}

\item{r_version}{R version(s) to use, the default is the current
R version, via \code{\link[=getRversion]{getRversion()}}.}

\item{bioc}{Whether to add the Bioconductor repositories. If you
already configured them via \code{options(repos)}, then you can
set this to \code{FALSE}. See \code{\link[=bioc_version]{bioc_version()}} for the details about
how pkgcache handles Bioconductor repositories.}

\item{cran_mirror}{The CRAN mirror to use, see
\code{\link[=default_cran_mirror]{default_cran_mirror()}}.}
}
\value{
A tibble that has a row for every repository, on every
queried platform and R version. It has these columns:
\itemize{
\item \code{name}: the name of the repository. This comes from the names
of the configured repositories in \code{options("repos")}, or
added by pkgcache. It is typically \code{CRAN} for CRAN, and the
current Bioconductor repositories are \code{BioCsoft}, \code{BioCann},
\code{BioCexp}, \code{BioCworkflows}.
\item \code{url}: base URL of the repository.
\item \code{bioc_version}: Bioconductor version, or \code{NA} for
non-Bioconductor repositories.
\item \code{platform}: platform, possible values are \code{source}, \code{macos} and
\code{windows} currently.
\item \code{path}: the path to the packages within the base URL, for a
given platform and R version.
\item \code{r_version}: R version, one of the specified R versions.
\item \code{ok}: Logical flag, whether the repository contains a metadata
file for the given platform and R version.
\item \code{ping}: HTTP response time of the repository in seconds. If
the \code{ok} column is \code{FALSE}, then this columns in \code{NA}.
\item \code{error}: the error object if the HTTP query failed for this
repository, platform and R version.
}
}
\description{
It checks the status of the configured or supplied repositories,
for the specified platforms and R versions.
}
\details{
The returned tibble has a \code{summary()} method, which shows
the same information is a concise table. See examples below.
}
\examples{
\dontshow{if (pkgcache:::is_online()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
repo_status()
rst <- repo_status(
  platforms = c("windows", "macos"),
  r_version = c("4.0", "4.1")
)
summary(rst)
\dontshow{\}) # examplesIf}
}
