% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa-async.R
\name{async_every}
\alias{async_every}
\alias{async_some}
\title{Do every or some elements of a list satisfy an asynchronous predicate?}
\usage{
async_every(.x, .p, ...)

async_some(.x, .p, ...)
}
\arguments{
\item{.x}{A list or atomic vector.}

\item{.p}{An asynchronous predicate function.}

\item{...}{Additional arguments to the predicate function.}
}
\value{
A deferred value for the result.
}
\description{
Do every or some elements of a list satisfy an asynchronous predicate?
}
\examples{
# Check if all numbers are odd
# Note the use of force() here. Otherwise x will be evaluated later,
# and by then its value might change.
is_odd <- async(function(x) {
  force(x)
  delay(1/1000)$then(function() as.logical(x \%\% 2))
})
synchronise(async_every(c(1,3,5,7,10,11), is_odd))
synchronise(async_every(c(1,3,5,7,11), is_odd))
}
\seealso{
Other async iterators: \code{\link{async_detect}},
  \code{\link{async_filter}}, \code{\link{async_map}}
}
\concept{async iterators}
