% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sprinkle_sanitize.R
\name{sprinkle_sanitize}
\alias{sprinkle_sanitize}
\alias{sprinkle_sanitize.default}
\alias{sprinkle_sanitize.dust_list}
\title{Sanitize Characters for LaTeX Outputs}
\usage{
sprinkle_sanitize(x, rows = NULL, cols = NULL, sanitize = NULL,
  sanitize_args = NULL, part = c("body", "head", "foot", "interfoot",
  "table"), fixed = FALSE, recycle = c("none", "rows", "cols",
  "columns"), ...)

\method{sprinkle_sanitize}{default}(x, rows = NULL, cols = NULL,
  sanitize = NULL, sanitize_args = NULL, part = c("body", "head",
  "foot", "interfoot", "table"), fixed = FALSE, recycle = c("none",
  "rows", "cols", "columns"), ...)

\method{sprinkle_sanitize}{dust_list}(x, rows = NULL, cols = NULL,
  sanitize = NULL, sanitize_args = NULL, part = c("body", "head",
  "foot", "interfoot", "table"), fixed = FALSE, recycle = c("none",
  "rows", "cols", "columns"), ...)
}
\arguments{
\item{x}{An object of class \code{dust}}

\item{rows}{Either a numeric vector of rows in the tabular object to be 
modified or an object of class \code{call}.  When a \code{call}, 
generated by \code{quote(expression)}, the expression resolves to 
a logical vector the same length as the number of rows in the table.
Sprinkles are applied to where the expression resolves to \code{TRUE}.}

\item{cols}{Either a numeric vector of columns in the tabular object to
be modified, or a character vector of column names. A mixture of 
character and numeric indices is permissible.}

\item{sanitize}{\code{logical(1)}. Should the code for the cell be sanitized.}

\item{sanitize_args}{A list of arguments to pass to 
\code{Hmisc::latexTranslate}}

\item{part}{A character string denoting which part of the table to modify.}

\item{fixed}{\code{logical(1)} indicating if the values in \code{rows} 
and \code{cols} should be read as fixed coordinate pairs.  By default, 
sprinkles are applied at the intersection of \code{rows} and \code{cols}, 
meaning that the arguments do not have to share the same length.  
When \code{fixed = TRUE}, they must share the same length.}

\item{recycle}{A \code{character} one that determines how sprinkles are 
managed when the sprinkle input doesn't match the length of the region
to be sprinkled.  By default, recycling is turned off.  Recycling 
may be performed across rows first (left to right, top to bottom), 
or down columns first (top to bottom, left to right).}

\item{...}{Additional arguments to pass to other methods. Currently ignored.}
}
\description{
Certain characters in LaTeX code need to be escaped to 
  prevent errors during processing.  For example, \code{\%} is the 
  comment character in LaTeX, and needs to be escaped in 
  order to render correctly.
}
\details{
This sprinkle is only recognized by LaTeX output.  See 
  \code{\link[Hmisc]{latexTranslate}} for more details.
}
\section{Functional Requirements}{

\enumerate{
 \item Correctly reassigns the appropriate elements of \code{sanitize} 
   and \code{sanitize_args} columns in the table part.
 \item Casts an error if \code{x} is not a \code{dust} object.
 \item Casts an error if \code{sanitize} is not a \code{logical(1)}
 \item Casts an error if \code{sanitize_args} is not a \code{list}
 \item Casts an error if \code{part} is not one of \code{"body"}, 
   \code{"head"}, \code{"foot"}, or \code{"interfoot"}
 \item Casts an error if \code{fixed} is not a \code{logical(1)}
 \item Casts an error if \code{recycle} is not one of \code{"none"},
   \code{"rows"}, or \code{"cols"}
}

The functional behavior of the \code{fixed} and \code{recycle} arguments 
is not tested for this function. It is tested and validated in the
tests for \code{\link{index_to_sprinkle}}.
}

\seealso{
\code{\link{sprinkle}}, 
  \code{\link{index_to_sprinkle}}
}
