% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save_clasif_image.R
\name{save_classif_image}
\alias{save_classif_image}
\title{Saves a classified image in TIFF or JPEG format}
\usage{
save_classif_image(classified_image, file_name, ...)
}
\arguments{
\item{classified_image}{an object of class \code{classified_image}.}

\item{file_name}{a character string with the name of the output file,
including the extension.}

\item{...}{further parameters to pass to functions \code{writeJPG} and
\code{writeTIFF}. If void, the default values of these functions are used.}
}
\value{
It does not return anything, only creates the file.
}
\description{
Creates an image file in TIFF or JPEG format from an array of class
\code{classified_image}.
}
\details{
The type of the output file (jpeg or tiff) is selected from the
  extension included in the file name. It must be one of \code{("jpg", "JPG",
  "jpeg", "JPEG", "tif", "TIF", "tiff", "TIFF")}.

  Note that the default value for jpg quality is 0.7. For maximal quality set
  \code{quality = 1} using the \dots argument. Such adjustments are not
  needed with \code{tiff} files, as this is a lossless format.
}
\examples{
\dontrun{

# Saving an hypothetical image. Note the use of quality to set the
# maximum quality level in the JPEG file
save_classif_image(image01_class, "./myimages/image01_classified.jpg",
                   quality = 1)
}

}
\seealso{
\code{\link{classify_pixels}}

  For more information about the options for file formatting see see the help
  pages of \code{\link[jpeg]{readJPEG}} and \code{\link[tiff]{readTIFF}}
  functions in packages \code{jpeg} and \code{tiff}, respectively.
}
