% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/story.R
\name{story}
\alias{story}
\alias{getStory}
\alias{createStory}
\alias{editStory}
\alias{deleteStory}
\title{Create, read, update, and delete a story}
\usage{
getStory(story)

createStory(...)

editStory(story, ...)

deleteStory(story)
}
\arguments{
\item{story}{An id string or URL to a Story}

\item{...}{Story attributes to either \code{createStory} or \code{editStory}. See a
list of valid attributes at
\url{https://www.pivotaltracker.com/help/api/rest/v5#projects_project_id_stories_post}.
\code{name} is required on creation; all other fields are optional.}
}
\value{
\code{deleteStory} returns nothing, while the other functions all return
a 'story' object: either the requested story (\code{getStory}), the newly
created story (\code{createStory}), or the current state of the modified story
\code{editStory}.
}
\description{
Create, read, update, and delete a story
}
\examples{
\dontrun{
new_bug <- createStory(
    name="Flux capacitor hangs at 0.9 gigawatts",
    description="Please investigate and fix.",
    story_type="bug"
)
new_bug <- editStory(new_bug, current_state="started")
deleteStory(new_bug)
}
}
