% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unpivot.R
\name{unpivot}
\alias{unpivot}
\title{Un-pivot a table}
\usage{
unpivot(data, key, value, ...)
}
\arguments{
\item{data}{A data frame.}

\item{key}{Names of new key and value columns, as strings or
symbols.

This argument is passed by expression and supports
\link[rlang:quasiquotation]{quasiquotation} (you can unquote strings
and symbols). The name is captured from the expression with
\code{\link[rlang:quo_name]{rlang::quo_name()}} (note that this kind of interface where
symbols do not represent actual objects is now discouraged in the
tidyverse; we support it here for backward compatibility).}

\item{value}{Names of new key and value columns, as strings or
symbols.

This argument is passed by expression and supports
\link[rlang:quasiquotation]{quasiquotation} (you can unquote strings
and symbols). The name is captured from the expression with
\code{\link[rlang:quo_name]{rlang::quo_name()}} (note that this kind of interface where
symbols do not represent actual objects is now discouraged in the
tidyverse; we support it here for backward compatibility).}

\item{...}{Selection criteria for columns to unpivot.}
}
\description{
Un-pivot a table
}
\examples{
# establish `db` as a database connection

library(dplyr)
library(dbplyr)
\dontshow{
   con <- simulate_mssql()
   src <- src_dbi(con)
   base <- list( x = ident('##iris')
               , vars  = tbl_vars(iris)
               ) \%>\% structure(class=c('op_base_remote', 'op_base', 'op'))
   db_iris <- structure( list( src = src
                             , ops = base
                             )
       , class = c('tbl_dbi', 'tbl_sql', 'tbl_lazy', 'tbl'))
}
\dontrun{
    db_iris <- copy_to(db, iris)
}
long.iris <- unpivot(db_iris, Variable, Value, Sepal.Length, Sepal.Width, Petal.Length, Petal.Width)
sql_render(long.iris)


}
