% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.R
\name{piv_sim}
\alias{piv_sim}
\title{Generate Data from a Gaussian Nested Mixture}
\usage{
piv_sim(N, k, Mu, stdev, Sigma.p1 = diag(2), Sigma.p2 = 100 * diag(2),
  W = c(0.5, 0.5))
}
\arguments{
\item{N}{The desired sample size.}

\item{k}{The desired number of mixture components.}

\item{Mu}{The input mean vector of length \eqn{k} for univariate
Gaussian mixtures; the input \eqn{k \times D} matrix with the
means' coordinates for multivariate Gaussian mixtures.}

\item{stdev}{For univariate mixtures, the  \eqn{k \times 2} matrix
of input standard deviations,
where the first column contains the parameters for subgroup 1,
and the second column contains the parameters for subgroup 2.}

\item{Sigma.p1}{The \eqn{D \times D} covariance matrix for the first subgroup. For multivariate mixtures only.}

\item{Sigma.p2}{The \eqn{D \times D} covariance matrix for the second subgroup. For multivariate mixtures only.}

\item{W}{The vector for the mixture weights of the two subgroups.}
}
\value{
\item{\code{y}}{The \eqn{N} simulated observations.}
\item{\code{true.group}}{A vector of integers from \eqn{1:k}
indicating the values of the latent variables \eqn{Z_i}.}
\item{\code{subgroups}}{A \eqn{k \times N} matrix where
each row contains the index subgroup for the observations
in the \eqn{k}-th group.}
}
\description{
Simulate \eqn{N} observations from a nested Gaussian mixture model
with \eqn{k} pre-specified components under uniform group probabilities \eqn{1/k},
where each group is in turn
drawn from a further level consisting of two subgroups.
}
\details{
The functions allows to simulate values from a double (nested) univariate
Gaussian mixture:

\deqn{
(Y_i|Z_i=j) \sim \sum_{s=1}^{2} p_{js}\, \mathcal{N}(\mu_{j}, \sigma^{2}_{js}),
}

or from a multivariate nested Gaussian mixture:

\deqn{
(Y_i|Z_i=j) \sim \sum_{s=1}^{2} p_{js}\, \mathcal{N}_{D}(\bm{\mu}_{j}, \Sigma_{s}),
}

where \eqn{\sigma^{2}_{js}} is the variance for the group \eqn{j} and
the subgroup \eqn{s} (\code{stdev} is the
argument for specifying the \code{k x 2} standard deviations
for univariate mixtures);
 \eqn{\Sigma_s} is the covariance matrix for the
subgroup \eqn{s, s=1,2}, where the two matrices are
specified by \code{Sigma.p1}
and \code{Sigma.p2} respectively; \eqn{\mu_j} and
\eqn{\bm{\mu}_j, \ j=1,\ldots,k}
  are the mean input vector and matrix respectively,
  specified by the argument \code{Mu};
\code{W} is a vector of dimension 2 for the subgroups weights.
}
\examples{

# Bivariate mixture simulation with three components

N  <- 2000
k  <- 3
D <- 2
M1 <- c(-45,8)
M2 <- c(45,.1)
M3 <- c(100,8)
Mu <- rbind(M1,M2,M3)
Sigma.p1 <- diag(D)
Sigma.p2 <- 20*diag(D)
W   <- c(0.2,0.8)
sim <- piv_sim(N = N, k = k, Mu = Mu, Sigma.p1 = Sigma.p1,
Sigma.p2 = Sigma.p2, W = W)
graphics::plot(sim$y, xlab="y[,1]", ylab="y[,2]")

}
