% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pir_run_true_tree.R
\name{pir_run_true_tree}
\alias{pir_run_true_tree}
\title{Measure the error BEAST2 makes from a phylogeny}
\usage{
pir_run_true_tree(true_phylogeny, pir_params)
}
\arguments{
\item{true_phylogeny}{the true phylogeny; the actual evolutionary
history of the species, of class \link[ape]{phylo}}

\item{pir_params}{the parameters of \link[pirouette]{pirouette}.
They are created by \link{create_pir_params}.}
}
\value{
a data frame with errors, with as many rows as model selection
  parameter sets
}
\description{
The phylogeny can be the true tree or its twin.
}
\examples{
if (beautier::is_on_ci()) {

  pir_params <- create_test_pir_params()

  # The user should never need to initialize the pir_params
  # but a develop calling this function needs to
 pir_params <- init_pir_params(pir_params)

  if (
    rappdirs::app_dir()$os != "win" &&
    beastier::is_beast2_installed()
  ) {
    pir_run_true_tree(
      true_phylogeny = ape::rcoal(4),
      pir_params = pir_params
    )
  }
}
}
\author{
Richèl J.C. Bilderbeek, Giovanni Laudanno
}
