% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/errorses_to_data_frame.R
\name{errorses_to_data_frame}
\alias{errorses_to_data_frame}
\title{Convert the collect of errors to a data frame}
\usage{
errorses_to_data_frame(errorses, experiments, marg_liks)
}
\arguments{
\item{errorses}{a collection of errors (hence the reduplicated plural)}

\item{experiments}{a list of one or more \link{pirouette} experiments,
as can be created by \link{create_experiment}. If more than one experiment
is provided and a "generative" experiment is part of them, the "generative"
one has to be the first in the list. See also:
\itemize{
  \item Use \link{check_experiments} to check the list of
    experiments for validity
  \item Use \link{create_all_experiments} to create experiments with
    all combinations of tree model, clock model and tree priors
  \item Use \link{create_all_bd_experiments} to create experiments
    with all combinations of tree model, clock model and tree priors,
    except for only using birth-death tree priors
  \item Use \link{create_all_coal_experiments} to create all experiments
    with all combinations of tree model, clock model and tree priors,
    except for only coalescent tree priors
  \item Use \link{shorten_experiments} to shorten the run time
    of the list of experiments
}}

\item{marg_liks}{a data frame with marginal likelihoods/evidences.
A test data frame can be created by \link{create_test_marg_liks}}
}
\value{
a data frame
}
\description{
Convert the collect of errors to a data frame
}
\examples{

if (beautier::is_on_ci() && beastier::is_beast2_installed()) {
  phylogeny <- ape::read.tree(text = "(((A:1, B:1):1, C:2):1, D:3);")
  pir_params <- create_test_pir_params()

  # A normal user should not need to call 'phylo_to_errors' directly.
  # For a developer that needs to, the 'pir_params' must be initialized
  pir_params <- init_pir_params(pir_params)

  create_tral_file(
    phylogeny = phylogeny,
    alignment_params = pir_params$alignment_params,
    verbose = FALSE
  )

  errorses <- list()
  errorses[[1]] <- phylo_to_errors(
    phylogeny = phylogeny,
    alignment_params = pir_params$alignment_params,
    error_measure_params = pir_params$error_measure_params,
    experiment = pir_params$experiments[[1]],
    verbose = pir_params$verbose
  )

  errorses_to_data_frame(
    errorses = errorses,
    experiments = list(pir_params$experiments[[1]]),
    marg_liks = create_test_marg_liks(
      site_models = list(beautier::create_jc69_site_model()),
      clock_models = list(beautier::create_strict_clock_model()),
      tree_priors = list(beautier::create_yule_tree_prior())
    )
  )
}
}
\author{
Richèl J.C. Bilderbeek, Giovanni Laudanno
}
