% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine_models.R
\name{combine_models}
\alias{combine_models}
\title{Combine a combination of site models, clock models and tree priors
into a collection of inference models.}
\usage{
combine_models(
  site_models = beautier::create_site_models(),
  clock_models = beautier::create_clock_models(),
  tree_priors = beautier::create_tree_priors()
)
}
\arguments{
\item{site_models}{a list of one or more site models,
as created by \link[beautier]{create_site_model}}

\item{clock_models}{a list of one or more clock models,
as created by \link[beautier]{create_clock_model}}

\item{tree_priors}{a list of one or more tree priors,
as created by \link[beautier]{create_tree_prior}}
}
\value{
a list of inference models
(see \link[beautier]{create_inference_model})
}
\description{
If there are `x` site models, `y` clock models and `z` tree priors,
this will result in `x * y * z` inference models.
}
\examples{
if (beautier::is_on_ci()) {
  site_models <- beautier::create_site_models()
  clock_models <- beautier::create_clock_models()
  tree_priors <- beautier::create_tree_priors()

  inference_models <- combine_models(
    site_models = site_models,
    clock_models = clock_models,
    tree_priors = tree_priors
  )
}
}
