% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{grid_inner}
\alias{grid_inner}
\title{Inner function for grid search}
\usage{
grid_inner(
  hyp_ncs,
  y_hat,
  ncs,
  pos_vals,
  alpha,
  return_min_q = FALSE,
  weights = NULL
)
}
\arguments{
\item{hyp_ncs}{vector of hypothetical non-conformity scores}

\item{y_hat}{predicted value}

\item{ncs}{vector of non-conformity scores}

\item{pos_vals}{vector of possible values for the lower and upper bounds of the prediction interval}

\item{alpha}{confidence level}

\item{return_min_q}{logical. If TRUE, the function will return the minimum quantile of the nonconformity scores for each predicted value}

\item{weights}{vector of weights for the weighted conformal prediction method}
}
\value{
a numeric vector with the predicted value and the lower and upper bounds of the prediction interval
}
\description{
Inner function for grid search
}
