% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/response.R
\docType{methods}
\name{response}
\alias{response}
\alias{response,pim-method}
\alias{response,pim.formula-method}
\title{Extract response from a pim.formula or a pim object}
\usage{
response(object)

\S4method{response}{pim.formula}(object)

\S4method{response}{pim}(object)
}
\arguments{
\item{object}{an object of class pim or pim.formula.}
}
\value{
The response variable with pseudo-observations for
a pim.
}
\description{
This function extracts the response from a 
\code{\link{pim.formula}} for use in \code{\link{pim.fit}}.
}
\examples{
data('FEVData')
Model <- pim(FEV~ Smoke*Sex , data=FEVData)
response(Model)

# In pieces
FEVenv <- new.pim.env(FEVData, compare="unique")
FEVform <- new.pim.formula(
  Age ~ I(L(Height) - R(Height))  ,
  FEVenv
)
response(FEVform)
}
\seealso{
\code{\link{pim-class}} and \code{\link{pim.formula-class}}
for more information on the classes, and \code{\link{pim}}, 
\code{\link{pim.fit}} and \code{\link{pim.formula}} for more
 information on related functions.
}

