% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pif_variance_linear.R
\name{pif.variance.linear}
\alias{pif.variance.linear}
\title{Approximate Variance for the Potential Impact Fraction}
\usage{
pif.variance.linear(X, thetahat, rr, thetavar, cft = NA,
  weights = rep(1/nrow(as.matrix(X)), nrow(as.matrix(X))),
  check_thetas = TRUE, check_cft = TRUE, check_exposure = TRUE,
  nsim = 1000, is_paf = FALSE)
}
\arguments{
\item{X}{Random sample (\code{data.frame}) which includes exposure and
covariates.}

\item{thetahat}{Estimator (\code{vector}) of \code{theta} for the Relative 
Risk function.}

\item{rr}{\code{function} for Relative Risk which uses parameter 
\code{theta}. The order of the parameters shound be \code{rr(X, theta)}.


**Optional**}

\item{thetavar}{Estimator of variance of \code{thetahat}}

\item{cft}{Function \code{cft(X)} for counterfactual. Leave empty for 
the Population Attributable Fraction \code{\link{paf}} where counterfactual 
is 0 exposure.}

\item{weights}{Normalized survey \code{weights} for the sample \code{X}.}

\item{check_thetas}{Checks that theta parameters are correctly inputed}

\item{check_cft}{Check if counterfactual function \code{cft} reduces 
exposure.}

\item{check_exposure}{Check that exposure \code{X} is positive and numeric}

\item{nsim}{Number of simulations for estimation of variance}

\item{is_paf}{Boolean to force paf evaluation.}
}
\description{
Function that calculates approximate variance of the potential 
 impact fraction \code{\link{pif}} (linearization).
}
\examples{

#Example 1: Exponential Relative risk
#--------------------------------------------
set.seed(18427)
X <- data.frame(rnorm(100,3,.5))
thetahat <- 0.12
thetavar <- 0.1
pif.variance.linear(X, thetahat, function(X, theta){exp(theta*X)}, 
                    thetavar, nsim = 100) 

#Same example with linear counterfactual
cft      <- function(X){0.3*X}
pif.variance.linear(X, thetahat, function(X, theta){exp(theta*X)}, 
                    thetavar, cft, nsim = 100) 
                    
#Example 2: Multivariate case
#--------------------------------------------
\dontrun{
set.seed(18427)
X1 <- rnorm(100, 3,.5)
X2 <- runif(100, 1, 1.5)
X  <- data.frame(cbind(X1,X2))
thetahat <- c(0.1, 0.03)
thetavar <- matrix(c(0.1, 0, 0, 0.05), byrow = TRUE, nrow = 2)
rr        <- function(X, theta){
           .X <- as.matrix(X, ncol = 2)
           exp(theta[1]*.X[,1] + theta[2]*.X[,2])
           }
cft <- function(X){0.5*X}
pif.variance.linear(X, thetahat, rr, thetavar, cft, nsim = 100) 
}
}
\seealso{
\code{\link{pif.variance.approximate.linear}} for \code{\link{pif}} 
 variance and \code{\link{pif.confidence}} for confidence intervals of
 \code{\link{pif}}
}
\author{
Rodrigo Zepeda-Tello \email{rzepeda17@gmail.com}

Dalia Camacho-García-Formentí \email{daliaf172@gmail.com}
}
\keyword{internal}
