\name{read.simmap}
\alias{read.simmap}
\title{Read SIMMAP style trees from file}
\usage{
read.simmap(file="",text,format="phylip",rev.order=TRUE)
}
\arguments{
  \item{file}{name of text file with one or multiple SIMMAP v1.0 style trees.}
  \item{text}{character string containing the tree.}
  \item{format}{format of the trees: either \code{"phylip"} or \code{"nexus"} - the latter is the default output from SIMMAP v1.0.}
  \item{rev.order}{a logical value indicating whether the states and times along each branch is given (from root to tip) in right-to-left order (if TRUE) or in left-to-right order.}
}
\description{
  This reads one or multiple SIMMAP style trees from file.
}
\details{
  This function does not yet accept trees in SIMMAP v1.5 format; however it does read a more flexible format than is produced by SIMMAP v1.0 (for instance, multi-character mapped states and more than 7 mapped states).  Uses some modified code from \code{\link{read.nexus}} from the "ape" package to read the NEXUS block created by SIMMAP.  Also creates the attribute \code{"map.order"} which indicates whether the stochastic map was read in from left to right or right to left.  This attribute is used by default by \code{\link{write.simmap}} to write the tree in the same order. 
}
\value{
  a modified phylogenetic tree of class \code{"phylo"} with the following additional elements:
  \item{maps}{a list of named vectors containing the times spent in each state on each branch, in the order in which they occur.}
  \item{mapped.edge}{a matrix containing the total time spent in each state along each edge of the tree.}
}
\references{
  Paradis, E., J. Claude, and K. Strimmer. 2004. APE: Analyses of phylogenetics and evolution in R language. \emph{Bioinformatics}, \bold{20}, 289--290.

  Bollback, J. P. 2006. Stochastic character mapping of discrete traits on phylogenies. \emph{BMC Bioinformatics}, \bold{7}, 88.
}
\author{Liam Revell \email{liam.revell@umb.edu}}
\seealso{
  \code{\link{brownie.lite}}, \code{\link{evol.vcv}}, \code{\link{read.tree}}, \code{\link{read.nexus}}
}
\examples{
X<-"((A:{aqua,0.3:terr,0.4:aqua,0.3},B:{aqua,1.0}):{aqua,1.0},(C:{aqua,0.25:terr,0.75},D:{aqua,1.0}):{aqua,1.0});"
phy<-read.simmap(text=X)
}
\keyword{phylogenetics}
