% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geo.phylo.R
\name{geo.phylo.ses}
\alias{geo.phylo.ses}
\title{Calculate phylogenetic community metrics and their standardized effect sizes
for raster data}
\usage{
geo.phylo.ses(
  x,
  tree,
  inv.R,
  edge.path,
  branch.length,
  n.descen,
  spat_alg = "bootspat_str",
  spat_alg_args = list(rprob = NULL, rich = NULL, fr_prob = NULL),
  random = c("tip", "spat")[2],
  aleats = 10,
  cores = 1,
  filename = "",
  ...
)
}
\arguments{
\item{x}{SpatRaster. A SpatRaster containing presence-absence data (0 or 1)
for a set of species. The layers (species) will be sorted according to the
tree order. See the phylo.pres function.}

\item{tree}{phylo. A dated tree.}

\item{inv.R}{SpatRaster. Inverse of range size. See \code{\link{inv.range}}}

\item{edge.path}{matrix representing the paths through the tree from root
to each tip. See \code{\link{phylo.pres}}}

\item{branch.length}{numeric. A Named numeric vector of branch length for
each species. See \code{\link{phylo.pres}}}

\item{n.descen}{numeric. A Named numeric vector of number of descendants for
each branch. See \code{\link{phylo.pres}}}

\item{spat_alg}{A function with the algorithm implementing the desired
randomization method. It must work with SpatRaster objects. See examples.
Example of functions that work are: \code{\link[SESraster]{bootspat_naive}},
\code{\link[SESraster]{bootspat_str}}, \code{\link[SESraster]{bootspat_ff}}.}

\item{spat_alg_args}{List of arguments passed to the randomization method
chosen in 'spat_alg'. See \code{\link[SESraster]{bootspat_naive}}, \code{\link[SESraster]{bootspat_str}},
\code{\link[SESraster]{bootspat_ff}}}

\item{random}{character. A character indicating the type of randomization.
The currently available randomization methods are "tip", "site", "species" or
"both" (site and species).}

\item{aleats}{positive integer. A positive integer indicating how many times
the calculation should be repeated.}

\item{cores}{positive integer. If \code{cores > 1}, a 'parallel' package cluster with that many cores is created and used. You can also supply a cluster object. Ignored for functions that are implemented by terra in C++ (see under fun)}

\item{filename}{character. Output filename}

\item{...}{additional arguments passed for terra::app}
}
\value{
SpatRaster
}
\description{
Calculates the standardized effect size for phylogenetic
community metrics. See Details for more information.
}
\details{
The spatial randomization (spat) keeps the richness exact
and samples
species presences proportionally to their observed frequency (i.e.
number of
occupied pixels). The randomization will not assign values to cells
with nodata.
}
\examples{
\donttest{
library(terra)
library(phyloraster)
require("SESraster")
x <- terra::rast(system.file("extdata", "rast.presab.tif",
package="phyloraster"))
tree <- ape::read.tree(system.file("extdata", "tree.nex",
package="phyloraster"))
tses <- geo.phylo.ses(x = x,
                     tree = tree,
                      # FUN_args = list(range.BL=area.branch$range.BL,
                      # inv.R=area.branch$inv.R,
                      # branch.length=data$branch.length,
                      # n.descen = data$n.descendants),
                      spat_alg = "bootspat_str",
                      spat_alg_args = list(rprob = NULL,
                                           rich = NULL,
                                           fr_prob = NULL),
                      aleats = 2)
terra::plot(tses)
}
}
\references{
Williams, P.H., Humphries, C.J., Forey, P.L., Humphries, C.J.,
VaneWright, R.I. (1994). Biodiversity, taxonomic relatedness, and endemism
in conservation. In: Systematics and Conservation Evaluation (eds Forey PL,
Humphries CJ, Vane-Wright RI), p. 438. Oxford University Press, Oxford.

Crisp, M., Laffan, S., Linder, H., Monro, A. (2001). Endemism
in the Australian flora. Journal of Biogeography, 28, 183–198.
}
\seealso{
\code{\link{phylo.pres}},
\code{\link{inv.range}},
\code{\link{geo.phylo}},
\code{\link{rast.ed.ses}},
\code{\link{rast.pd.ses}},
\code{\link{rast.we.ses}},
\code{\link{rast.pe.ses}},
\code{\link[SESraster]{bootspat_str}},
\code{\link[SESraster]{bootspat_naive}},
\code{\link[SESraster]{bootspat_ff}},
\code{\link[SESraster]{SESraster}}
}
\author{
Neander Marcel Heming
}
