% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asdendrogram.R
\name{as.dendrogram.phylo}
\alias{as.dendrogram.phylo}
\title{Convert "phylo" objects to dendrograms.}
\usage{
\method{as.dendrogram}{phylo}(object, ...)
}
\arguments{
\item{object}{a "phylo" object.}

\item{...}{further arguments to be passed between methods.}
}
\value{
an object of class "dendrogram".
}
\description{
These functions are used for converting dendrograms to "phylo" objects
  and \emph{vice versa}.
}
\details{
These functions currently work by temporarily writing a tree to Newick
  text and then parsing the string using either \code{\link{read.dendrogram}}
  or \code{\link[ape]{read.tree}}. A faster implementation that avoids the
  transformation to text strings will be available in a future version.
}
\examples{
  newick <- "(A:0.1,B:0.2,(C:0.3,D:0.4):0.5);"
  x <- read.dendrogram(text = newick)
  y <- as.phylo(x)
  z <- as.dendrogram(y)
  identical(x, z)
}
\author{
Shaun Wilkinson
}
