% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phreeqc.R
\docType{data}
\name{ex17}
\alias{ex17}
\title{Example 17--Inverse Modeling With Evaporation}
\source{
\url{http://wwwbrr.cr.usgs.gov/projects/GWC_coupled/phreeqc}
}
\description{
Evaporation is handled in the same manner as other
heterogeneous reactions for inverse modeling. To model evaporation (or
dilution), it is necessary to include a phase with the composition "H2O".
The important concept in modeling evaporation is the water mole-balance
equation (see Parkhurst and Appelo, 1999, "Equations and Numerical Method
for Inverse Modeling"). The moles of water in the initial solutions times
their mixing fractions, plus water gained or lost by dissolution or
precipitation of phases, plus water gained or lost through redox reactions,
must equal the moles of water in the final solution. The equation is still
approximate because it does not include the moles of water gained or lost in
hydrolysis and complexation reactions in the solutions. The results of
inverse modeling are compared with a forward model using Pitzer equations to
calculate the sequence of salts that precipitate during evaporation. The
example can be run using the \code{\link{phrRunString}} routine.
}
\examples{

phrLoadDatabaseString(pitzer.dat)
phrSetOutputStringsOn(TRUE)
phrRunString(ex17)
phrGetOutputStrings()

}
\references{
\url{https://pubs.usgs.gov/tm/06/a43/pdf/tm6-A43.pdf}
}
\seealso{
Other Examples: 
\code{\link{ex1}},
\code{\link{ex10}},
\code{\link{ex11}},
\code{\link{ex12}},
\code{\link{ex13a}},
\code{\link{ex14}},
\code{\link{ex15}},
\code{\link{ex16}},
\code{\link{ex18}},
\code{\link{ex19}},
\code{\link{ex2}},
\code{\link{ex20a}},
\code{\link{ex21}},
\code{\link{ex22}},
\code{\link{ex3}},
\code{\link{ex4}},
\code{\link{ex5}},
\code{\link{ex6}},
\code{\link{ex7}},
\code{\link{ex8}},
\code{\link{ex9}}
}
\concept{Examples}
\keyword{dataset}
