% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/photobiologyInOut.r
\docType{package}
\name{photobiologyInOut-package}
\alias{photobiologyInOut}
\alias{photobiologyInOut-package}
\title{photobiologyInOut: Read Spectral and Logged Data from Foreign Files}
\description{
Functions for reading, and in some cases writing, foreign files 
    containing spectral data from spectrometers and their associated software, 
    output from daylight simulation models in common use, and some spectral 
    data repositories. As well as functions for exchange of spectral data with 
    other R packages. Part of the 'r4photobiology' suite, 
    Aphalo P. J. (2015) <doi:10.19232/uv4pb.2015.1.14>.
}
\note{
From version 0.4.4 the time zone (tz) used for decoding dates
  and times in files imported defaults to "UTC". In most cases you will need
  to pass the tz (or the locale) where the file was created as an argument to
  the functions!
}
\section{Warning!}{
 Most of the file formats supported are not standardized,
  and are a moving target because of changes in instrument firmware and
  support software. In addition the output format, especially with models,
  can depend on settings that users can alter. So do check that import is
  working as expected, and if not, please please raise an issuet and upload
  one example of an incorrectly decoded file.
}

\references{
Aphalo, Pedro J. (2015) The r4photobiology suite. UV4Plants Bulletin, 2015:1,
21-29. \url{https://doi.org/10.19232/uv4pb.2015.1.14}.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://docs.r4photobiology.info/photobiologyInOut/}
  \item Report bugs at \url{https://bitbucket.org/aphalo/photobiologyinout/issues/}
}

}
\author{
\strong{Maintainer}: Pedro J. Aphalo \email{pedro.aphalo@helsinki.fi} (\href{https://orcid.org/0000-0003-3385-972X}{ORCID})

Other contributors:
\itemize{
  \item Titta K. Kotilainen (\href{https://orcid.org/0000-0002-2822-9734}{ORCID}) [contributor]
  \item Glenn Davis \email{gdavis@gluonics.com} [contributor]
}

}
