#' Filter spectra data for commercial grenhouse films from BPI Visqueen
#'
#' Datasets containing the wavelengths at a 1 nm interval and
#' tabulated values spectral transmittance for different films used as
#' greenhouse cladding.
#'
#' The variables are as follows:
#'
#' \itemize{
#'   \item w.length (nm)
#'   \item Tfr (fraction)
#' }
#'
#' \url{http://www.rpc-bpi.com/agriculture/}
#'
#' Instrument used: Shimadzu UV-2501 PC (Shimadzu Suzhou Instruments Manufacturing
#' Co. Ltd, China) equiped with an integrating sphere.
#'
#' @note Idependent measurement of a single sample, not a specification.
#'
#' @docType data
#' @keywords datasets
#' @format A vector of character strings.
#'
#' @examples
#' bpi_visqueen_filters
#'
"bpi_visqueen_filters"
