% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapPheno.R
\name{mapPheno}
\alias{mapPheno}
\title{Convert a series of raster files to a single phenology raster.}
\usage{
mapPheno(File_List = NA, PhenoFactor = NA, phase = NA, threshold = NA,
  year = NA, NDVI = NA, VIQ = NA, DOY = NA, PR = NA,
  SnowExtent = NA, parallel = FALSE, n.cores = NA, verbose = FALSE)
}
\arguments{
\item{File_List}{List of raster files}

\item{PhenoFactor}{Character string; type of dataset to analyze (e.g., "VI", "Snow")}

\item{phase}{Character string; name of phenophase to be measured (e.g., "greenup", "snowmelt", "senescence" or other arguments passed to phenex::phenophase())}

\item{threshold}{Float threshold GWI value to be projected. Use only for VI option.}

\item{year}{Integer Year (YYYY)}

\item{NDVI}{Integer Band number of NDVI band in raster files}

\item{VIQ}{Integer Band number of VI Quality layer in raster files}

\item{DOY}{Integer Band number of Composite Day of Year layer in raster files}

\item{PR}{Integer Band Number of PR layer in raster files}

\item{SnowExtent}{Integer Band number of Maximum_Snow_Extent in raster files}

\item{parallel}{TRUE or FALSE (Default = FALSE) if TRUE, use parallel backend through plyr::aaply}

\item{n.cores}{Integer number of cores to be used for parallel processing (only use if parallel = TRUE)}

\item{verbose}{TRUE or FALSE (Default = FALSE)}
}
\value{
Raster object with extent=extent(raster(File_List)[1]) and CRS = crs(raster(File_List)[1]).  Digital numbers are expressed as Day of Year.
}
\description{
Convert a series of raster files to a single phenology raster.
}
\examples{
\dontshow{
fpath <- system.file("extdata", package="phenomap")
File_List <- paste(fpath, list.files(path = fpath, pattern=c("ExCrop_")), sep="/")
File_List <- File_List[1:2]

PhenoFactor = "VI"
phase = "greenup"
threshold = 0.5
year = 2016
NDVI = 1
VIQ = 3
DOY = 4
PR = 5
parallel = FALSE
n.cores = NA
verbose = FALSE

}
\dontrun{

Sample.Greenup <- mapPheno(File_List = File_List, PhenoFactor = PhenoFactor,
                           phase = phase, threshold = threshold, year = year,
                           NDVI = NDVI, VIQ = VIQ, DOY = DOY, PR = PR,
                           SnowExtent = SnowExtent,
                           parallel = parallel, n.cores = n.cores,
                           verbose = verbose)

}
}
