% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitRMU.R
\name{fitRMU}
\alias{fitRMU}
\title{Adjust incomplete timeseries with various constraints.}
\usage{
fitRMU(RMU.data = stop("data parameter must be provided"),
  years.byrow = TRUE, RMU.names = NULL, model.trend = "Constant",
  model.rookeries = "Constant", model.SD = "Global-constant",
  parameters = NULL, fixed.parameters = NULL, SE = NULL,
  method = c("Nelder-Mead", "BFGS"), control = list(trace = 1, REPORT = 100,
  maxit = 1500), itnmax = c(1500, 1500), hessian = TRUE,
  replicate.CI = 1000, colname.year = "Year", maxL = 1e+09)
}
\arguments{
\item{RMU.data}{A data.frame with a column Year (the name is defined in colname.year) and two columns per rookery defined in RMU.names}

\item{years.byrow}{If TRUE, the RMU.data data.frame is organized with years in rows}

\item{RMU.names}{A dataframe with two columns indicating name of columns for mean and standard error for roockerys}

\item{model.trend}{Can be Constant, Exponential or Year-specific}

\item{model.rookeries}{Description temporal change in rookeries proportion. It be Constant, First-order or Second-order}

\item{model.SD}{Can be Zero, Global-constant, Global-proportional or Rookery-constant. See description.}

\item{parameters}{Parameters to fit}

\item{fixed.parameters}{Parameters that are fixed}

\item{SE}{Parameters SE for example from fitRMU_MHmcmc()}

\item{method}{Methods to be used by optimx()}

\item{control}{List of controls for optimx()}

\item{itnmax}{A vector with maximum iterations for each method.}

\item{hessian}{If TRUE, the hessian matrix is calculated and then the standard error of parameters.}

\item{replicate.CI}{Number of replicates to estimate CI of proportion for each rookery}

\item{colname.year}{Name of the column to be used as time index}

\item{maxL}{If an error is produced during the estimation of likelihood, replace -Ln L by this value}
}
\value{
Return a list with the results from optim and synthesis for proportions and numbers
}
\description{
The data must be a data.frame with the first column being years \cr
and two columns for each beach: the average and the se for the estimate.\cr
The correspondance between mean and se for each rookery are given in the RMU.names data.frame.\cr
In the result list, the mean proportions for each rookeries are in $proportions, $proportions.CI.0.05 and $proportions.CI.0.95.\cr
The names of beach columns must not begin by T_, SD_, a0_, a1_ or a2_ and cannot be r.\cr
A RMU is the acronyme for Regional Managment Unit. See:\cr
Wallace, B.P., DiMatteo, A.D., Hurley, B.J., Finkbeiner, E.M., Bolten, A.B., 
Chaloupka, M.Y., Hutchinson, B.J., Abreu-Grobois, F.A., Amorocho, D., Bjorndal, K.A., 
Bourjea, J., Bowen, B.W., Dueñas, R.B., Casale, P., Choudhury, B.C., Costa, A., 
Dutton, P.H., Fallabrino, A., Girard, A., Girondot, M., Godfrey, M.H., Hamann, M., 
López-Mendilaharsu, M., Marcovaldi, M.A., Mortimer, J.A., Musick, J.A., Nel, R., 
Seminoff, J.A., Troëng, S., Witherington, B., Mast, R.B., 2010. Regional 
management units for marine turtles: a novel framework for prioritizing 
conservation and research across multiple scales. PLoS One 5, e15465.\cr
Variance for each value is additive based on both the observed SE (in the RMU.data 
object) and a constant value dependent on the rookery when model.SD is equal to 
"beach-constant". The value is a global constant when model.SD is "global-constant". 
The value is proportional to the observed number of nests when model.SD is 
"global-proportional" with aSD_*observed+SD_ with aSD_ and SD_ being fitted 
values. This value is fixed to zero when model.SD is "Zero".
}
\details{
fitRMU is used to estimate missing information when several linked values are observed along a timeseries
}
\examples{
\dontrun{
library("phenology")
RMU.names.AtlanticW <- data.frame(mean=c("Yalimapo.French.Guiana", 
                                         "Galibi.Suriname", 
                                         "Irakumpapy.French.Guiana"), 
                                 se=c("se_Yalimapo.French.Guiana", 
                                      "se_Galibi.Suriname", 
                                      "se_Irakumpapy.French.Guiana"))
data.AtlanticW <- data.frame(Year=c(1990:2000), 
      Yalimapo.French.Guiana=c(2076, 2765, 2890, 2678, NA, 
                               6542, 5678, 1243, NA, 1566, 1566),
      se_Yalimapo.French.Guiana=c(123.2, 27.7, 62.5, 126, NA, 
                                 230, 129, 167, NA, 145, 20),
      Galibi.Suriname=c(276, 275, 290, NA, 267, 
                       542, 678, NA, 243, 156, 123),
      se_Galibi.Suriname=c(22.3, 34.2, 23.2, NA, 23.2, 
                           4.3, 2.3, NA, 10.3, 10.1, 8.9),
      Irakumpapy.French.Guiana=c(1076, 1765, 1390, 1678, NA, 
                               3542, 2678, 243, NA, 566, 566),
      se_Irakumpapy.French.Guiana=c(23.2, 29.7, 22.5, 226, NA, 
                                 130, 29, 67, NA, 15, 20))
                           
cst <- fitRMU(RMU.data=data.AtlanticW, RMU.names=RMU.names.AtlanticW, 
               colname.year="Year", model.trend="Constant", 
               model.SD="Zero")
cst <- fitRMU(RMU.data=data.AtlanticW, RMU.names=RMU.names.AtlanticW, 
               colname.year="Year", model.trend="Constant", 
               model.SD="Zero", 
               control=list(trace=1, REPORT=100, maxit=500, parscale = c(3000, -0.2, 0.6)))
               
# Example with optimx
require("optimx")
cst <- fitRMU(RMU.data=data.AtlanticW, RMU.names=RMU.names.AtlanticW, 
               colname.year="Year", model.trend="Constant", 
               model.SD="Zero", optim="optimx", method=c("Nelder-Mead","BFGS"), 
               control = list(trace = 0, REPORT = 100, maxit = 500, 
               parscale = c(3000, -0.2, 0.6)))
expo <- fitRMU(RMU.data=data.AtlanticW, RMU.names=RMU.names.AtlanticW, 
               colname.year="Year", model.trend="Exponential", 
               model.SD="Zero", optim="optimx", method=c("Nelder-Mead","BFGS"), 
               control = list(trace = 0, REPORT = 100, maxit = 500, 
               parscale = c(6000, -0.05, -0.25, 0.6)))
YS <- fitRMU(RMU.data=data.AtlanticW, RMU.names=RMU.names.AtlanticW, 
             colname.year="Year", model.trend="Year-specific", method=c("Nelder-Mead","BFGS"), 
             optim="optimx", model.SD="Zero")
YS1 <- fitRMU(RMU.data=data.AtlanticW, RMU.names=RMU.names.AtlanticW, 
             colname.year="Year", model.trend="Year-specific", method=c("Nelder-Mead","BFGS"), 
             optim="optimx", model.SD="Zero", model.rookeries="First-order")
YS1_cst <- fitRMU(RMU.data=data.AtlanticW, RMU.names=RMU.names.AtlanticW, 
             colname.year="Year", model.trend="Year-specific", 
             model.SD="Constant", model.rookeries="First-order", 
             optim="optimx", parameters=YS1$par, method=c("Nelder-Mead","BFGS"))
YS2 <- fitRMU(RMU.data=data.AtlanticW, RMU.names=RMU.names.AtlanticW, 
             colname.year="Year", model.trend="Year-specific",
             model.SD="Zero", model.rookeries="Second-order", 
             optim="optimx", parameters=YS1$par, method=c("Nelder-Mead","BFGS"))
YS2_cst <- fitRMU(RMU.data=data.AtlanticW, RMU.names=RMU.names.AtlanticW, 
             colname.year="Year", model.trend="Year-specific",
             model.SD="Constant", model.rookeries="Second-order", 
             optim="optimx", parameters=YS1_cst$par, method=c("Nelder-Mead","BFGS"))
               
compare_AIC(Constant=cst, Exponential=expo, 
YearSpecific=YS)

compare_AIC(YearSpecific_ProportionsFirstOrder_Zero=YS1,
YearSpecific_ProportionsFirstOrder_Constant=YS1_cst)

compare_AIC(YearSpecific_ProportionsConstant=YS,
           YearSpecific_ProportionsFirstOrder=YS1,
           YearSpecific_ProportionsSecondOrder=YS2)
           
compare_AIC(YearSpecific_ProportionsFirstOrder=YS1_cst,
           YearSpecific_ProportionsSecondOrder=YS2_cst)

barplot_errbar(YS1_cst$proportions[1, ], y.plus = YS1_cst$proportions.CI.0.95[1, ], 
y.minus = YS1_cst$proportions.CI.0.05[1, ], las=1, ylim=c(0, 0.7), 
main="Proportion of the different rookeries in the region")

plot(cst, main="Use of different beaches along the time", what="total")
plot(expo, main="Use of different beaches along the time", what="total")
plot(YS2_cst, main="Use of different beaches along the time", what="total")

plot(YS1, main="Use of different beaches along the time")
plot(YS1_cst, main="Use of different beaches along the time")
plot(YS1_cst, main="Use of different beaches along the time", what="numbers")

}
}
\seealso{
Other Fill gaps in RMU: \code{\link{fitRMU_MHmcmc_p}},
  \code{\link{fitRMU_MHmcmc}}, \code{\link{logLik.fitRMU}},
  \code{\link{plot.fitRMU}}
}
\author{
Marc Girondot
}
