% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Tagloss_model.R
\name{Tagloss_model}
\alias{Tagloss_model}
\title{Return the daily rate of tag loss.}
\usage{
Tagloss_model(t, par)
}
\arguments{
\item{t}{Time for which values of model must be estimated}

\item{par}{Parameter}
}
\value{
Return the daily rate of tag loss.
}
\description{
This function compute a model of daily tag loss rate for days t 
based on a set of parameters, par.\cr
}
\details{
Tagloss_model returns the daily rate of tag loss.
}
\examples{
library(phenology)
\dontrun{
# Example
t <- 1:1000
par <- c(D1=200, D2D1=100, D3D2=200, 
         A=-logit(0.02), B=-logit(0.05), C=-logit(0.07))
y <- Tagloss_model(t, par)
plot(x=t, y, type="l")
}
}
\seealso{
Other Model of Tag-loss: \code{\link{Tagloss_LengthObs}},
  \code{\link{Tagloss_L}}, \code{\link{Tagloss_daymax}},
  \code{\link{Tagloss_fit}}, \code{\link{Tagloss_format}},
  \code{\link{Tagloss_simulate}},
  \code{\link{logLik.Tagloss}}, \code{\link{plot.Tagloss}}
}
\author{
Marc Girondot
}
