% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phenophases.r
\name{phenophases}
\alias{phenophases}
\title{Calculates phenophases, for rising and falling parts of a time series}
\usage{
phenophases(data, mat = NULL, internal = TRUE, out_dir = tempdir(), ...)
}
\arguments{
\item{data}{a PhenoCam data file (or data frame)}

\item{mat}{mean annual temperature}

\item{internal}{return PhenoCam data file or data frame}

\item{out_dir}{output directory}

\item{...}{pass parameters to the transition_dates() function}
}
\value{
Estimates of transition dates for both rising and falling parts of a
PhenoCam time series. All time series are evaluated (gcc_90, gcc_75, etc).
The function returns a nested list with UNIX time based values
including uncertainties on these estimates and their associated 
thresholds. When written to disk UNIX dates are converted to YYYY-MM-DD.
The nested list has named locations rising and falling, or location 1 and 2
in the list respectivelly.
}
\description{
This routine combines a forward and backward
run of transition_dates function to calculate the phenophases in both
rising and falling parts of a PhenoCam time series.
}
\examples{

\donttest{
# downloads a time series
download_phenocam(site = "harvard$",
                  veg_type = "DB",
                  roi_id = "1",
                  frequency = "3")

# read in data as data frame and calculate phenophases
df <- read_phenocam(paste0(tempdir(),"/harvard_DB_0001_3day.csv"))
my_dates <- phenophases(df, internal = TRUE)

# print results
print(my_dates)
}
}
\keyword{PhenoCam,}
\keyword{dates,}
\keyword{phenology,}
\keyword{series}
\keyword{time}
\keyword{transition}
