% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pml_bb.R
\name{pml_bb}
\alias{pml_bb}
\title{Likelihood of a tree.}
\usage{
pml_bb(x, model = NULL, rearrangement = "stochastic",
  method = "unrooted", start = NULL, tip.dates = NULL, ...)
}
\arguments{
\item{x}{An alignment of class (either class \code{phyDat}, \code{DNAbin} or
\code{AAbin}) or an object of class \code{modelTest}.}

\item{model}{A string providing model (e.g. "GTR+G(4)+I"). Not necessary if
a modelTest object is supplied.}

\item{rearrangement}{Type of tree tree rearrangements to perform, one of
"none", "NNI", "stochastic" or "ratchet"}

\item{method}{One of "unrooted", "ultrametric" or "tiplabeled".}

\item{start}{A starting tree can be supplied.}

\item{tip.dates}{A named vector of sampling times associated to the tips /
sequences.}

\item{\dots}{Further arguments passed to or from other methods.}
}
\value{
\code{pml_bb} returns an object of class pml.
}
\description{
\code{pml_bb} for pml black box infers a phylogentic tree infers a tree using
maximum likelihood (ML).
}
\details{
\code{pml_bb} is a convenience function combining \code{pml} and
\code{optim.pml}. If no tree is supplied, the function will generate a
starting tree. If a modelTest object is supplied the model will be chosen
according to BIC.

Currently very experimental and likely to change.
}
\examples{

\dontrun{
data(woodmouse)
tmp <- pml_bb(woodmouse)

data(Laurasiatherian)
mt <- modelTest(Laurasiatherian)
fit <- pml_bb(mt)
}
}
\seealso{
\code{\link{optim.pml}}, \code{\link{modelTest}}, \code{\link{rtt}}
}
\author{
Klaus Schliep \email{klaus.schliep@gmail.com}
}
\keyword{cluster}
