% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clone.R
\name{clone}
\alias{clone}
\title{clone}
\usage{
clone(iter, parent = rlang::env_parent(iter))
}
\arguments{
\item{iter}{an \code{Iterator} object}

\item{parent}{the environment to put the \code{Iterator}}
}
\value{
a copy of the \code{Iterator} passed as a parameter
}
\description{
Clone an Iterator, making an exact copy that can then be modified separately.
This is a simple wrapper around \code{\link[rlang:env_clone]{rlang::env_clone()}}. Includes the option to
clone the Iterator into a different environment.
}
\examples{
it <- Iterator('m <- m + 1', c(m = 0), m)
other <- clone(it)
yield_next(it)
current(other) == current(it) # false
}
