% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appReset.R
\name{appResetButton}
\alias{appResetButton}
\title{appResetButton module UI function}
\usage{
appResetButton(id)
}
\arguments{
\item{id}{character id for the object}
}
\value{
an html div with prettyToggle button
}
\description{
Creates a toggle button to reset application session. Upon pressing on the
 button, its state is flipped to cancel application reload with application
 and console warning messages indicating that the application will be
 reloaded.
}
\details{
User can either resume reloading application session or cancel reloading
 process which will also generate application and console messages to
 indicate reloading status and result.
}
\section{Button Features}{

\itemize{
    \item Initial state label is "Application Reset" with warning status
    \item Reloading state label is "Cancel Application Reset" with danger
          status
}
}

\section{Shiny Usage}{

Call this function at any place in UI section.

It is paired with a call to \code{appReset(id, ...)}
in server
}

\examples{
if (interactive()) {
   library(shiny)
   library(periscope2)
   shinyApp(
     ui = fluidPage(fluidRow(column(12, appResetButton(id = "appResetId")))),
     server = function(input, output) {
       appReset(id = "appResetId", logger = "")
   })
}


}
\seealso{
\link[periscope2]{appReset}

\link[periscope2]{downloadFile}

\link[periscope2]{downloadFile_ValidateTypes}

\link[periscope2]{downloadFile_AvailableTypes}

\link[periscope2]{downloadablePlot}

\link[periscope2]{downloadFileButton}

\link[periscope2]{downloadableTable}

\link[periscope2]{logViewerOutput}
}
