% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logger.R
\name{getHandler}
\alias{getHandler}
\title{Retrieves a handler from a logger.}
\usage{
getHandler(handler, logger = "")
}
\arguments{
\item{handler}{The name of the handler, or its action.}

\item{logger}{Optional: the name of the logger. Defaults to the root logger.}
}
\value{
The retrieved handler object. It returns NULL if handler is not registered.
}
\description{
Handlers are not uniquely identified by their name. Only within the logger to which
they are attached is their name unique. This function is here to allow you grab a
handler from a logger so you can examine and alter it.

Typical use of this function is in \code{setLevel(newLevel, getHandler(...))}.
}
