% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_dend_utility_functions.R
\name{dendToNewick}
\alias{dendToNewick}
\title{Convert a list data structure to Newick format}
\usage{
dendToNewick(dend, sep = "-")
}
\arguments{
\item{dend}{A list of nodes that represents the nested partition of haplotypes.}

\item{sep}{A separator for haplotype names in the same clade. See the arguments in
\code{\link{reconstructPP}}.}
}
\value{
A character string in Newick format.
}
\description{
This function traverses the dendogram to build the character string that represents the dendrogram in
Newick format.
}
\examples{

\dontshow{

data(ex_hapMatSmall_data)

# First, select a window of SNVs about a focal SNV.
SNV_win <- selectWindow(hapMat = ex_hapMatSmall_data,
                        focalSNV = 10, minWindow = 1)
                        
# Then order SNVs in the window.
ordHapmat <- orderSNVs(snvWin = SNV_win)

# Recursively partition haplotype matrix.
partitions <- makePartition(hapmat = ordHapmat, splitSNV = 1)

# Dendrogram in Newick format.
newickDend <- dendToNewick(dend = partitions, sep = "-")

}

}
\seealso{
\code{\link{makeDend}}
}
\keyword{internal}
