% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_percentiles.R
\name{calculate_stratified_percentiles}
\alias{calculate_stratified_percentiles}
\title{Calculate stratified percentiles}
\usage{
calculate_stratified_percentiles(data, value_col, stratify_by, use.na = FALSE)
}
\arguments{
\item{data}{A data frame}

\item{value_col}{character name of column containing values}

\item{stratify_by}{list or vector. Use a named list to specify column name as key and a value of type vector indicating accepted levels of the property stratified by to be included. If an unnamed list or vector is passed, all levels of indicated columns will be used}

\item{use.na}{A logical indicating whether NA values should be used. If TRUE, NA values and non-included value levels will be grouped like a separate value level}
}
\value{
A vector of numerics with percentile values of length of nrow(data)
}
\description{
Calculate percentiles for values in a data.frame while stratifying for other characteritics in same df
}
\examples{
data <- data.frame('values' = 100:1, 'group' = rep(c('A', 'B', NA, 'D'), 25))
calculate_stratified_percentiles(data, 'values', 'group')
calculate_stratified_percentiles(data, 'values', list(group = c('A', 'B', 'D')))
calculate_stratified_percentiles(data, 'values', c('group'), use.na = TRUE)
calculate_stratified_percentiles(data, 'values', list(group = c('A', 'C')), use.na=TRUE)

}
\author{
Peter Marquardt
}
