% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pensynth.R
\name{pensynth}
\alias{pensynth}
\title{Penalized synthetic control estimator}
\usage{
pensynth(
  X1,
  X0,
  v,
  lambda = 0,
  opt_pars = clarabel::clarabel_control(),
  standardize = TRUE
)
}
\arguments{
\item{X1}{\verb{N_covars by 1 matrix} of treated unit covariates}

\item{X0}{\verb{N_covars by N_donors matrix} of donor unit covariates}

\item{v}{\verb{N_covars vector} of variable weights}

\item{lambda}{\code{numeric} penalization parameter}

\item{opt_pars}{\code{clarabel} settings using \code{\link[clarabel:clarabel_control]{clarabel::clarabel_control()}}}

\item{standardize}{\code{boolean} whether to standardize the input matrices (default TRUE)}
}
\value{
A list with two values: \code{w}, the estimated weights; and
\code{solution}, the result of the optimization.
}
\description{
For a given set of variable weights (v) this function estimates
the unit weights for a synthetic control with penalization
according to Abadie & L'Hour (2021). This function deals with only a
single treated unit.
}
\details{
This routine uses the same notation of the original \code{\link[Synth:synth]{Synth::synth()}} implementation
but uses a different, faster quadratic program solver (namely, \code{\link[osqp:osqp]{osqp::osqp()}}). Additionally, it
implements the penalization procedure described in Abadie & L'Hour (2021), such that the loss
function is as in equation 5 of that paper (but for a single treated unit).

Variable weights are not optimized by this function, meaning they need to be pre-specified.
This is by design.

The original synthetic control method can be recovered by setting lambda = 0. For determining
lambda based on data, see \code{\link[=cv_pensynth]{cv_pensynth()}}.
}
\examples{
# generate some data
X0 <- matrix(
  c(1, 1.3,
    0.5, 1.8,
    1.1, 2.4,
    1.8, 1.8,
    1.3, 1.8), 2)
X1 <- matrix(c(0.8, 1.65), 2)
v <- rep(1, 2)

# run classic synthetic control (no penalization)
res <- pensynth(X1, X0, v)
plot(t(X0))
points(t(X1), pch = 2)
points(t(X0\%*\%res$w), pch = 3)

# run synthetic control with penalty
res <- pensynth(X1, X0, v, lambda = 0.5)
points(t(X0 \%*\% res$w), pch = 4)

}
\references{
Abadie, A., & L’Hour, J. (2021).
A penalized synthetic control estimator for disaggregated data.
\emph{Journal of the American Statistical Association, 116}(536), 1817-1834.
}
\seealso{
\code{\link[=cv_pensynth]{cv_pensynth()}} \code{\link[Synth:synth]{Synth::synth()}}
}
