% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{mloc}
\alias{mloc}
\title{Compute the M-estimate of Location}
\usage{
mloc(x, scale, rho = "bisquare", eff = 0.9, cc, max_it = 200, eps = 1e-08)
}
\arguments{
\item{x}{numeric values. Missing values are verbosely ignored.}

\item{scale}{scale of the \code{x} values. If omitted, uses the \link[stats:mad]{mad()}.}

\item{rho}{the \eqn{\rho} function to use. See \code{\link[=rho_function]{rho_function()}} for available functions.}

\item{eff}{desired efficiency under the Normal model.}

\item{cc}{value of the tuning constant for the chosen \eqn{\rho} function.
If specified, overrides the desired efficiency.}

\item{max_it}{maximum number of iterations.}

\item{eps}{numerical tolerance to check for convergence.}
}
\value{
a single numeric value, the M-estimate of location.
}
\description{
Compute the M-estimate of location using an auxiliary estimate of the scale.
}
\seealso{
Other functions to compute robust estimates of location and scale: 
\code{\link{mlocscale}()},
\code{\link{mscale}()},
\code{\link{tau_size}()}
}
\concept{functions to compute robust estimates of location and scale}
