% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{mlocscale}
\alias{mlocscale}
\title{Compute the M-estimate of Location and Scale}
\usage{
mlocscale(
  x,
  bdp = 0.25,
  scale_cc = consistency_const(bdp, "bisquare"),
  location_rho,
  location_cc,
  opts = mscale_algorithm_options()
)
}
\arguments{
\item{x}{numeric values. Missing values are verbosely ignored.}

\item{bdp}{desired breakdown point (between 0 and 0.5).}

\item{scale_cc}{cutoff value for the bisquare \eqn{\rho} function for computing the scale estimate. By default, chosen
to yield a consistent estimate for normally distributed values.}

\item{location_rho, location_cc}{\eqn{\rho} function and cutoff value for computing the location estimate.
See \code{\link[=rho_function]{rho_function()}} for a list of available \eqn{\rho} functions.}

\item{opts}{a list of options for the M-estimating equation,
see \code{\link[=mscale_algorithm_options]{mscale_algorithm_options()}} for details.}
}
\value{
a vector with 2 elements, the M-estimate of location and the M-scale estimate.
}
\description{
Simultaneous estimation of the location and scale by means of M-estimates.
}
\seealso{
Other functions to compute robust estimates of location and scale: 
\code{\link{mloc}()},
\code{\link{mscale}()},
\code{\link{tau_size}()}
}
\concept{functions to compute robust estimates of location and scale}
