% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prinsens.R
\name{prinsens}
\alias{prinsens}
\title{Principal Sensitivity Components}
\usage{
prinsens(
  x,
  y,
  method = c("ols", "en"),
  intercept = TRUE,
  alpha,
  lambda,
  en_options = en_options_aug_lars()
)
}
\arguments{
\item{x}{data matrix with predictors}

\item{y}{response vector}

\item{method}{use ordinary least squares (\code{"ols"}) or elastic net
(\code{"en"}) to compute the PSCs.}

\item{intercept}{Should an intercept be added or not.}

\item{alpha, lambda}{The values for the parameters controlling the
penalization for elastic net.}

\item{en_options}{additional options for the EN algorithm. See
\code{\link{en_options}} for details.}
}
\value{
A numeric matrix with as many rows as \code{x} and as many columns as
     PSCs found (at most the number of columns in \code{x} plus one for the
     intercept). Each column is a PSC.
}
\description{
Compute the principal sensitivity components (PSC) for regression.
}
\examples{
set.seed(12345)
n <- 50
n_out <- 6
p <- 500
beta <- c(2:5, numeric(p - 4))
x <- 1 + matrix(rnorm(n * p), ncol = p)
y <- x \%*\% beta  + rnorm(n)

# add outliers to y
y[seq_len(n_out)] <- rnorm(n_out, -100, 0.5)

# Compute Principal Sensitivity Components
pscs <- prinsens(
    x, y,
    alpha = 0.8,
    method = "en",
    lambda = 10
)

# The 6 outlying observations are reflected in the 15th PSC
colors <- rep.int(c(2, 1), times = c(n_out, n - n_out))
ord <- order(abs(pscs[, 15L]))
plot(abs(pscs[ord, 15L]), col = colors[ord], xlab = "Sorted Index",
     ylab = "Absolute PSC score")

}
\references{
Pena, D., and Yohai, V.J. (1999).
    A Fast Procedure for Outlier Diagnostics in Large Regression Problems.
    \emph{Journal of the American Statistical Association}, \bold{94}(446),
    434-445. \url{http://doi.org/10.2307/2670164}
}
