% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{penfaPredict}
\alias{penfaPredict}
\title{Compute the factor scores from a fitted \code{penfa} model}
\usage{
penfaPredict(
  object,
  newdata = NULL,
  method = "regression",
  label = TRUE,
  append.data = FALSE,
  assemble = FALSE
)
}
\arguments{
\item{object}{An object of class \code{\linkS4class{penfa}}.}

\item{newdata}{An optional data frame containing the same variables as the
ones appearing in the original data frame used for fitting the model in
\code{object}.}

\item{method}{Character indicating the method for computing the factor
scores. Possible options are \code{"regression"} and \code{"bartlett"}. For
the normal linear continuous case, the regression method is equivalent to
the Empirical Bayes Method (EBM), whereas Bartlett's strategy is equivalent
to maximum likelihood's method.}

\item{label}{Logical. If \code{TRUE}, the columns are labeled.}

\item{append.data}{Logical. If \code{TRUE}, the original data set (or the
data set provided in the \code{newdata} argument) is appended to the factor
scores.}

\item{assemble}{Logical. If \code{TRUE}, the factor scores from each group
are assembled in a single data frame of the same dimensions as the original
data set and with a group column defining the groups.}
}
\value{
A matrix with the factor scores from a fitted \code{penfa} model.
}
\description{
The \code{penfaPredict} function estimates the factor scores
from a fitted penalized factor model. The factor scores are the estimated
values ("predictions") of the common factors.
}
\examples{

data(ccdata)

syntax = 'help  =~   h1 + h2 + h3 + h4 + h5 + h6 + h7 + 0*v1 + v2 + v3 + v4 + v5
          voice =~ 0*h1 + h2 + h3 + h4 + h5 + h6 + h7 +   v1 + v2 + v3 + v4 + v5'

alasso_fit <- penfa(## factor model
                    model  = syntax,
                    data   = ccdata,
                    std.lv = TRUE,
                    ## penalization
                    pen.shrink = "alasso",
                    eta = list(shrink = c("lambda" = 0.01), diff = c("none" = 0)),
                    ## automatic procedure
                    strategy = "auto",
                    gamma = 4)

fscores <- penfaPredict(alasso_fit)

}
\references{
Geminiani E. (2020), "A penalized likelihood-based framework for
single and multiple-group factor analysis models" (Doctoral dissertation,
University of Bologna). Available at
\url{http://amsdottorato.unibo.it/9355/}.
}
\seealso{
\code{\link{penfa}}
}
