\name{4.2.referencing.pems.data}
\alias{4.2.referencing.pems.data}
\alias{referencing.pems.data}
\alias{refRow}
\alias{refX}
\alias{refEngineOn}
\alias{refDrivingMode}


\title{
  Data Referencing Functions.
}

\description{
  Various functions for grouping, subsetting, filtering 
  and conditioning datasets.
}

\usage{

refRow(ref = NULL, n = 4, breaks = NULL, 
        data = NULL, ..., labels = NULL,
        fun.name = "refRow")

refX(ref = NULL, n = 4, breaks = NULL, 
        method = "percentile", 
        data = NULL, ..., labels = NULL,
        fun.name = "refX")
        
refEngineOn(rpm = NULL, data = NULL, 
        threshold = 200, ..., labels = NULL, 
        fun.name = "refEngineOn")
        
refDrivingMode(speed = NULL, accel = NULL,
        time = NULL, data = NULL, 
        threshold.speed = 0.1, 
        threshold.accel = 0.1,
        ..., labels = NULL, 
        fun.name = "refDrivingMode")

}




\arguments{

  \item{ref}{
  (Data series, typically vector) The reference data-series 
  to consider when making a vector of subset 
  markers/indices. See Details.
} 

  \item{n, breaks}{
  (numerics) With \code{refRow} and \code{refX}, 
  \code{n} sets the number of equal intervals to 
  attempt to cut the data into. With \code{refRow}, 
  \code{breaks} sets the rows at which to cut 
  the data at. With \code{refX}, \code{breaks} sets 
  the values of \code{ref} to cut the data at. In both 
  cases, if both \code{n} and \code{breaks} are set, 
  \code{breaks} is applied. 
}

  \item{data}{
  (Optional \code{data.frame} or \code{pems} object) The 
  data source if \code{ref} is supplied in either 
  a \code{data.frame} or \code{pems} object.
} 

  \item{\dots}{
  (Optional) Other arguments, currently passed on to 
  \code{pems.utils} management functions.
}

  \item{labels}{
  (Vector, typically Character) a vector of labels to be 
  assigned to the reference regions. 
} 

  \item{fun.name}{
  (function managment argument) \code{fun.name} is the 
  name of the parent function, to be used in 
  error messaging. 
}

  \item{method}{
  (Various) For \code{refX}, the method to use when 
  cutting data. If character vector, \code{'percentile'} 
  or \code{'range'}. If function, it should be in form 
  \code{function(ref, n)}, and return breaks.
}
 
  \item{rpm}{
  For \code{refEngineOn}, the input, assumed to be engine 
  speed and expected to have units of rpm. 
}
  
  \item{threshold}{
  For \code{refEngineOn}, the signal threshold above which 
  the vehicle engine is assumed to be on.
}

  \item{speed,accel,time}{
  For \code{refDrivingMode}, possible inputs. Strictly, 
  \code{refDrivingMode} needs \code{speed} and \code{accel} 
  but can use \code{speed} and \code{time} to build 
  \code{accel}. 
}

  \item{threshold.speed,threshold.accel}{
  For \code{refDrivingMode}, the speed and acceleration 
  signal thresholds. Below these thresholds the signals are 
  assumed to be noise and the vehicle is not moving or 
  accelerating, respectively. 
}

   
}


\details{

  \code{ref...} functions generate a vector 
  of subset markers or indices based of the referencing  
  method applied and the length of \code{ref}. 
  See Value regarding outputs.

  \code{refRow} assigns reference regions based on row 
  number. Because row depends on the length of the 
  \code{ref} element independent of values, this is a 
  unique case where \code{ref} can be either a vector or 
  a data set (\code{pems}, \code{data.frame}). It accepts 
  \code{n} to set the number of cases to make or 
  \code{breaks} to set break-points at specific rows.
  
  \code{refX} assigns reference regions based on the value 
  of a supplied data-series.It accepts \code{n} to set the 
  number of cases to make or \code{breaks} to set the 
  \code{ref} values to make break-points. If using \code{n},
  \code{method} used to assign cut method, e.g. 
  \code{'percentile'} or \code{'range'}.

  \code{refEngineOn} assigns reference regions based on 
  engine operation status. It uses the input, which it assumes 
  is engine speed, and assumes reported engine speeds larger 
  than the supplied threshold, by default 200 rpm, indicate 
  that the engine is on.
  
  \code{refDrivingMode} assigns reference regions based on 
  vehicle driving mode. It uses inputs, assumed to be 
  \code{speed}, \code{accel} and/or \code{accel}, and 
  associated threshold to characterize activity as 
  \code{decel}, \code{idle}, \code{cruise} or \code{accel}. 
  
}


\value{

  By default results are returned as 
  \code{\link{pems.element}}s. 

  The reference vector generated by \code{ref...} 
  functions can then be used to group, subset, filter 
  or condition data in \code{pems} objects.
  
  \code{refRow} assigns reference according to row number, 
  and, by default, reference labels show \code{start row} and 
  \code{end row} of the referenced case. 
  
  \code{refX} assigns reference according to value of supplied 
  input, and, by default, reference labels show 
  \code{lower value} and \code{higher value} of the referenced 
  case.
  
  \code{refEngineOn} assigns reference according to engine 
  operation status based on engine speed, and, by default, 
  reference labels are \code{'on'} or \code{'off'}.
  
  \code{refDrivingMode} assigns reference according to vehicle
  driving mode, based on vehicle speed, acceleration and 
  associated thresholds, and, by default, 
  reference labels are \code{decel}, \code{idle}, 
  \code{cruise} and \code{accel}.

}

\references{
  References in preparation.
}
\author{
  Karl Ropkins
}
\note{
  With \code{refRow}, If \code{n} is applied and the length 
  of \code{ref} is not exactly divisible by \code{n} 
  a best attempt is made.
  
  With \code{refX}, if \code{breaks} are at values that are 
  duplicated, all same values are assigned to the same (lower) 
  value case, so e.g. \code{'percentile'} may vary significantly 
  if break-point values are highly duplicated in \code{ref}
  
}


\seealso{
  \code{\link{cut}}, etc. in the main R package.
}

\examples{

###########
##example 1 
###########

#basic usage

#working with a temporary pems

temp <- pems.1

#cut into equal subsets

temp$ref <- refRow(velocity, n= 5, data=temp)
pemsPlot(local.time, velocity, cond=ref, data=temp, 
             type="l", layout=c(1,5))

#cut at three points

temp <- pems.1
temp$ref <- refRow(velocity, breaks=c(180,410,700), 
             data=temp)

pemsPlot(local.time, velocity, cond=ref, data=temp, 
             type="l", layout=c(1,5))

}

\keyword{ methods }
