% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/likelihood.R
\name{likelihood}
\alias{likelihood}
\alias{likelihood.ped}
\alias{likelihood.list}
\title{Pedigree likelihood}
\usage{
likelihood(x, ...)

\method{likelihood}{ped}(
  x,
  marker1 = NULL,
  marker2 = NULL,
  rho = NULL,
  setup = list(),
  eliminate = 0,
  logbase = NULL,
  loop_breakers = NULL,
  verbose = FALSE,
  theta = NULL,
  ...
)

\method{likelihood}{list}(x, marker1, marker2 = NULL, logbase = NULL, total = TRUE, ...)
}
\arguments{
\item{x}{A \code{ped} object, a \code{singleton} object, or a list of such objects.}

\item{\dots}{Further arguments.}

\item{marker1}{One or several markers compatible with \code{x}. Several input
forms are possible:
\itemize{
\item A \code{\link[=marker]{marker()}} object compatible with \code{x}.
\item A list of marker objects
\item A vector of names or indices of markers attached to \code{x}. If \code{x} is a
list, this is the only valid input.
}}

\item{marker2}{Either NULL, or a single marker compatible with \code{x}. See
Details.}

\item{rho}{The recombination rate between \code{marker1} and \code{marker2}. To make
biological sense \code{rho} should be between 0 and 0.5.}

\item{setup}{For internal use.}

\item{eliminate}{Mostly for internal use: a non-negative integer indicating
the number of iterations in the internal genotype-compatibility algorithm.
Positive values can save time if the number of alleles is large.}

\item{logbase}{A numeric, or NULL. If numeric the log-likelihood is returned,
with \code{logbase} as basis for the logarithm.}

\item{loop_breakers}{A vector of ID labels indicating loop breakers. If NULL
(default), automatic selection of loop breakers will be performed. See
\code{\link[=breakLoops]{breakLoops()}}.}

\item{verbose}{A logical.}

\item{theta}{Deprecated; renamed to \code{rho}.}

\item{total}{A logical; if TRUE, the product of the likelihoods is returned,
otherwise a vector with the individual likelihoods.}
}
\value{
A numeric with the same length as the number of markers indicated by
\code{marker1}. If \code{logbase} is a positive number, the output is
\code{log(likelihood, logbase)}.
}
\description{
This function is the heart of pedprobr. It computes the likelihood of a
pedigree (or a list of pedigrees) given genotypes for a marker or a pair of
linked markers.
}
\details{
The implementation is based on the peeling algorithm of Elston and Stewart
(1971). A variety of situations are covered; see the Examples section for
some demonstrations.
\itemize{
\item complex inbred pedigrees
\item pedigrees with inbred founders
\item autosomal and X-linked markers
\item a single marker or two linked markers
\item markers with mutation models
}
}
\examples{

### Example 1: Likelihood of trio with inbred father

x = cousinPed(0, child = TRUE)
x = addSon(x, 5)
x = relabel(x, old = 5:7, new = c("father", "mother", "child"))

# Equifrequent SNP marker: father homozygous, child heterozygous
m = marker(x, father = 1, child = 1:2)
x = addMarkers(x, m)

# Plot with genotypes
plot(x, marker = 1)

# Compute the likelihood
lik1 = likelihood(x, marker1 = 1)


### Example 2: Same as above, but using founder inbreeding

# Extract the trio
y = subset(x, c("father", "mother", "child"))

# Indicate that the father has inbreeding coefficient 1/4
founderInbreeding(y, "father") = 1/4

# Plot (notice the inbreeding coefficient)
plot(y, marker = 1)

# Likelihood should be the same as above
lik2 = likelihood(y, marker1 = 1)

stopifnot(all.equal(lik1, lik2))


### Example 3: Modelling mutations
# TODO after next pedtools release

}
\references{
Elston and Stewart (1971). \emph{A General Model for the Genetic
Analysis of Pedigree Data}. \doi{https://doi.org/10.1159/000152448}
}
\author{
Magnus Dehli Vigeland
}
