% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getASelfing.R
\name{getASelfing}
\alias{getASelfing}
\title{Extends the pedigree according to number of selfing cycles
and also optionally computes the Additive Relationship Matrix for that pedigree.}
\usage{
getASelfing(
  ID,
  Par1,
  Par2,
  nCycles,
  nCyclesDefault,
  sepChar = "-F",
  verbose = FALSE,
  fileNewPed = NULL,
  computeA = TRUE
)
}
\arguments{
\item{ID}{is a vector of individual IDs}

\item{Par1}{vector of IDs of one of the parents}

\item{Par2}{vector of IDs of the other parent}

\item{nCycles}{vector that indicates number of selfing cycles for each individual.}

\item{nCyclesDefault}{default value of nCycles}

\item{sepChar}{character, used for expanded pedigree IDs}

\item{verbose}{logical, print progress}

\item{fileNewPed}{Output csv file (comma separated value) with columns 'label', 'sire', 'dam', with the full pull pedigree expanded taking into account the selfing cycles}

\item{computeA}{Indicates if the A matrix is to be computed}
}
\value{
Returns A matrix computed for the extended pedigree if computeA=TRUE
}
\description{
Extends the pedigree according to number of selfing cycles
and also optionally computes the Additive Relationship Matrix for that pedigree.
}
