% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peakRAM.R
\name{peakRAM}
\alias{peakRAM}
\title{Calculate Peak RAM Used}
\usage{
peakRAM(...)
}
\arguments{
\item{...}{R expressions or function calls. Anonymous functions
(e.g., \code{function() 1:1e7}) also accepted.}
}
\value{
A \code{data.frame} tallying total and peak RAM use.
}
\description{
This function monitors the total and peak RAM used by any number of
 R expressions or functions.
}
\details{
When working with big datasets, RAM conservation is critically
 important. However, it is not always enough to just monitor the
 size of the objects created. So-called "copy-on-modify" behavior,
 characteristic of R, means that some expressions or functions may
 require an unexpectedly large amount of RAM overhead. For example,
 replacing a single value in a matrix (e.g., with \code{'[<-'})
 duplicates that matrix in the backend, making this task
 require twice as much RAM as that used by the matrix itself.
 The \code{peakRAM} package makes it easy to monitor the total
 and peak RAM used so that developers can quickly identify and
 eliminate RAM hungry code.
}
\examples{
peakRAM(function() 1:1e7,
        1:1e7,
        1:1e7 + 1:1e7,
        1:1e7 * 2)
}

