% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R, R/new_p.R, R/new_d.R, R/new_q.R,
%   R/new_r.R
\name{methods-print}
\alias{methods-print}
\alias{print.p}
\alias{print.d}
\alias{print.q}
\alias{print.r}
\title{Pdqr methods for print function}
\usage{
\method{print}{p}(x, ...)

\method{print}{d}(x, ...)

\method{print}{q}(x, ...)

\method{print}{r}(x, ...)
}
\arguments{
\item{x}{Pdqr-function to print.}

\item{...}{Further arguments passed to or from other methods.}
}
\description{
Pdqr-functions have their own methods for \code{\link[=print]{print()}} which displays function's
\link[=meta_all]{metadata} in readable and concise form.
}
\details{
Print output of pdqr-function describes the following information:
\itemize{
\item Full name of function \link[=meta_class]{class}:
\itemize{
\item P-function is "Cumulative distribution function".
\item D-function is "Probability mass function" for "discrete" type and
"Probability density function" for "continuous".
\item Q-function is "Quantile function".
\item R-function is "Random generation function".
}
\item \link[=meta_type]{Type} of function in the form "of * type" where "*" is
"discrete" or "continuous" depending on actual type.
\item \link[=meta_support]{Support} of function.
\item Number of elements in distribution for "discrete" type or number of
intervals of piecewise-linear density for "continuous" type.
\item If pdqr-function has "discrete" type and exactly two possible values 0 and
1, it is treated as "boolean" pdqr-function and probability of 1 is shown.
This is done to simplify interactive work with output of comparing functions
like \code{>=}, etc. (see \link[=methods-group-generic]{description of methods for S3 group generic functions}). To extract probabilities from "boolean"
pdqr-function, use \code{\link[=summ_prob_true]{summ_prob_true()}} and \code{\link[=summ_prob_false]{summ_prob_false()}}.
}

Symbol "~" in \code{print()} output indicates that printed value or support is an
approximation to a true one (for readability purpose).
}
\examples{
print(new_d(1:10, "discrete"))

r_unif <- as_r(runif, n_grid = 251)
print(r_unif)

# Printing of boolean pdqr-function
print(r_unif >= 0.3)

}
\seealso{
Other pdqr methods for generic functions: \code{\link{methods-group-generic}},
  \code{\link{methods-plot}}
}
\concept{pdqr methods for generic functions}
