% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{sample_map}
\alias{sample_map}
\title{Plot the sampling map}
\usage{
sample_map(
  metadata,
  mode = 1,
  map_params = list(),
  group = NULL,
  point_params = list(),
  label = NULL,
  label_params = list(),
  shp_file = NULL,
  crs = NULL,
  xlim = NULL,
  ylim = NULL,
  add_scale = TRUE,
  scale_params = list(),
  add_north_arrow = TRUE,
  north_arrow_params = list()
)
}
\arguments{
\item{metadata}{metadata must contains  "Longitude","Latitude"}

\item{mode}{1~3. 1 use basic data from ggplot2. 2 use a shp_file. 3 use the leaflet.}

\item{map_params}{parameters parse to geom_polygon (mode=1) or geom_sf (mode=2)}

\item{group}{one column name of metadata which mapping to point color}

\item{point_params}{parameters parse to geom_point}

\item{label}{one column name of metadata which mapping to point label}

\item{label_params}{parameters parse to geom_sf_text}

\item{shp_file}{a geojson file parse to \code{sf::read_sf}}

\item{crs}{crs coordinate: \code{https://asa-blog.netlify.app/p/r-map/#crs}}

\item{xlim}{xlim}

\item{ylim}{ylim}

\item{add_scale}{add annotation_scale}

\item{scale_params}{parameters parse to \code{ggspatial::annotation_scale}}

\item{add_north_arrow}{add annotation_north_arrow}

\item{north_arrow_params}{parameters parse to \code{ggspatial::annotation_north_arrow}}
}
\value{
map
}
\description{
Plot the sampling map
}
\examples{
\donttest{
data(otutab)
anno_df <- metadata[, c("Id", "long", "lat", "Group")]
colnames(anno_df) <- c("Id", "Longitude", "Latitude", "Group")
sample_map(anno_df, mode = 1, group = "Group", xlim = c(90, 135), ylim = c(20, 50))
}
}
