% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibrateLb.r
\name{calibrateLb}
\alias{calibrateLb}
\title{Calibrate Inter-locus Balance}
\usage{
calibrateLb(sim = 100, target, amount = 0.5, cell.dna = 0.006,
  pcr.cyc = 30, acc.dev = 0.001, step.size = 0.001, seed = 0.85,
  max.eff = 0.98, progress = TRUE, debug = FALSE)
}
\arguments{
\item{sim}{integer the number of simulations per calibration cycle.}

\item{target}{numeric vector with target interlocus balances.}

\item{amount}{numeric for amount of DNA in ng.}

\item{cell.dna}{numeric the DNA content of a diploid cell in nanograms (default is 0.006 ng).}

\item{pcr.cyc}{integer the number of PCR cycles.}

\item{acc.dev}{numeric, accepted deviation from target.}

\item{step.size}{numeric, the probability of PCR is changed by this value.}

\item{seed}{numeric, start value for optimisation of the PCR probability.}

\item{max.eff}{numeric, maximal value for estimated PCR efficiency.}

\item{progress}{logical, print progress to console.}

\item{debug}{logical to print debug information.}
}
\value{
vector with estimated PCR efficiencies for each locus.
}
\description{
Estimate values for the PCR efficiency parameter per locus that satisfy
the target inter-locus balances.
}
\details{
The inter-locus balance for a kit should be characterised during the
internal validation of the kit. The function search for PCR efficiency
values per locus that upon simulation are similar to the target
inter-locus balances. Use the PCR efficiency value obtained from the
\code{calibratePCRsim} function as \code{seed} value.
}
\examples{
# Experimental inter-locus balances for the STR kit to be simulated (sums to 1).
target <- c(0.20, 0.10, 0.15, 0.25, 0.30)
 
# Find PCR efficiency values that upon simulation
# satisfy the experimental data for 0.5 ng of input DNA.
set.seed(10) # For reproducibility.
calibrateLb(sim=10, target=target, amount=0.5, seed=0.85, progress=FALSE)

# Locus specific PCR efficency parameters can now be used as parameters.
# [1] 0.858 0.816 0.841 0.871 0.883 
}
