% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helperfuns.R
\name{riskset}
\alias{riskset}
\title{Compute the risk set indicator}
\usage{
riskset(
  formula = formula(data),
  data = sys.parent(),
  contrasts.arg = NULL,
  xlevs = NULL,
  scaleX = TRUE,
  na.action = na.omit
)
}
\arguments{
\item{formula}{Object of class formula describing 
the model. The response and terms are specified 
similar to \code{\link[survival]{Surv}} function.}

\item{data}{optional data frame containing 
variables specified in the formula.}

\item{contrasts.arg}{an optional list. See 
the contrasts.arg of
\code{[stats]{model.matrix.default}}.}

\item{xlevs}{a named list of character vectors 
giving the full set of levels to be assumed 
for each factor. See \code{[stats]{model.frame}}.}

\item{scaleX}{logical. If TRUE (default), 
predictors are scaled/standardized. This is 
used internally.}

\item{na.action}{a function which indicates 
what should happen when the data contain NAs. 
See \code{[stats]{model.frame}}.}
}
\value{
A list of survival objects:
\item{Y}{Surv object defining the event times and event status.}
\item{X}{model matrix of model terms.}
\item{events}{observed events.}
\item{times}{event times defined by risk set condition.}
\item{timevarlabel, eventvarlabel}{time and event variables, respectively.}
\item{scale_sd, scale_mu}{standard deviation and mean of each of the variable used in standardization.}
}
\description{
Identify set of individuals at risk of 
experiencing the event before event time 
(failure time), \eqn{t_i}. The risk set, 
\eqn{R_i}, is the set of individuals, 
\eqn{j}, who had not experienced the 
event or had been censored by time \eqn{t_i}. 
This function identifies this set and 
computes event times satisfying this.
}
\details{
Let \eqn{t_1 < t_2 <, ..., t_m}, such
that \eqn{m < n} if there are not ties, 
otherwise \eqn{m = n}. If covariates are 
time-independent the risk set, \eqn{R_i},
is the set of individuals who are still at risk
at time \eqn{t_i}, i.e., individuals with
event/censoring time \eqn{y_j\ge t_i}.
For time-dependent covariates risk set at time 
\eqn{t_i} is now defined as 
\eqn{R(t_i) = \{j : (y^{stop}_{j} \ge t_i) \wedge (y^{start}_{j} < t_i)\}}.
The first condition, \eqn{(y^{stop}_{j} \ge t_i)}, 
ensures that individual \eqn{j} either experienced 
the event or was censored at a later time point than 
\eqn{t_i}, while the second condition, 
\eqn{(y^{start}_{j} < t_i)}, ensures the start 
time was observed before the event.
}
\keyword{internal}
