% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PropEdge2D.R
\name{Idom.num2PEbasic.tri}
\alias{Idom.num2PEbasic.tri}
\title{The indicator for two points being a dominating set for
Proportional Edge Proximity Catch Digraphs (PE-PCDs) -
standard basic triangle case}
\usage{
Idom.num2PEbasic.tri(
  p1,
  p2,
  Xp,
  r,
  c1,
  c2,
  M = c(1, 1, 1),
  rv1 = NULL,
  rv2 = NULL,
  ch.data.pnts = FALSE
)
}
\arguments{
\item{p1, p2}{Two 2D points to be tested for
constituting a dominating set of the PE-PCD.}

\item{Xp}{A set of 2D points
which constitutes the vertices of the PE-PCD.}

\item{r}{A positive real number
which serves as the expansion parameter in PE proximity region;
must be \eqn{\ge 1}.}

\item{c1, c2}{Positive real numbers
which constitute the vertex of the standard basic triangle.
adjacent to the shorter edges; \eqn{c_1} must be in \eqn{[0,1/2]},
\eqn{c_2>0} and \eqn{(1-c_1)^2+c_2^2 \le 1}.}

\item{M}{A 2D point in Cartesian coordinates
or a 3D point in barycentric coordinates
which serves as a center
in the interior of the standard basic triangle \eqn{T_b}
or the circumcenter of \eqn{T_b}
which may be entered as "CC" as well;
default is \eqn{M=(1,1,1)}, i.e., the center of mass of \eqn{T_b}.}

\item{rv1, rv2}{The indices of the vertices
whose regions contains \code{p1} and \code{p2}, respectively.
They take the vertex labels as \eqn{1,2,3} as
in the row order of the vertices in \eqn{T_b}
(default is \code{NULL} for both).}

\item{ch.data.pnts}{A logical argument for
checking whether points \code{p1} and \code{p2}
 are data points in \code{Xp} or not
(default is \code{FALSE}).}
}
\value{
\eqn{I(}\{\code{p1,p2}\} is a dominating set of the PE-PCD\eqn{)}
where the vertices of the PE-PCD are the 2D data set \code{Xp},
that is, returns 1 if \{\code{p1,p2}\} is a dominating set of PE-PCD,
and returns 0 otherwise.
}
\description{
Returns \eqn{I(}\{\code{p1,p2}\} is
a dominating set of the PE-PCD\eqn{)}
where the vertices of the PE-PCD are the 2D data set \code{Xp}
in the standard basic triangle
\eqn{T_b=T((0,0),(1,0),(c_1,c_2))},
that is, returns 1 if \{\code{p1,p2}\} is a dominating set of PE-PCD,
and returns 0 otherwise.

PE proximity regions are defined with respect to \eqn{T_b}.
In the standard basic triangle, \eqn{T_b},
\eqn{c_1} is in \eqn{[0,1/2]}, \eqn{c_2>0}
and \eqn{(1-c_1)^2+c_2^2 \le 1}.

Any given triangle can be mapped to the standard basic triangle
by a combination of rigid body motions
(i.e., translation, rotation and reflection) and scaling,
preserving uniformity of the points in the
original triangle.
Hence, standard basic triangle is useful for simulation
studies under the uniformity hypothesis.

Vertex regions are based on center \eqn{M=(m_1,m_2)} in Cartesian
coordinates or \eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates
in the interior of a standard basic triangle \eqn{T_b};
default is \eqn{M=(1,1,1)}, i.e., the center of mass of \eqn{T_b}.
Point, \code{p1},
is in the vertex region of vertex \code{rv1}
(default is \code{NULL});
and point, \code{p2},
is in the vertex region of vertex \code{rv2}
(default is \code{NULL});
vertices are labeled as \eqn{1,2,3}
in the order they are stacked row-wise.

\code{ch.data.pnts} is for checking
whether points \code{p1} and \code{p2} are both data points
in \code{Xp} or not (default is \code{FALSE}),
so by default this function checks
whether the points \code{p1} and \code{p2} would constitute
a dominating set
if they both were actually in the data set.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:dom-num-NPE-Spat2011;textual}{pcds}).
}
\examples{
\dontrun{
c1<-.4; c2<-.6;
A<-c(0,0); B<-c(1,0); C<-c(c1,c2);
Tb<-rbind(A,B,C)
n<-10  #try also n<-20

set.seed(1)
Xp<-runif.basic.tri(n,c1,c2)$g

M<-as.numeric(runif.basic.tri(1,c1,c2)$g)  #try also M<-c(.6,.3)

r<-2

Idom.num2PEbasic.tri(Xp[1,],Xp[2,],Xp,r,c1,c2,M)

Idom.num2PEbasic.tri(c(1,2),c(1,3),rbind(c(1,2),c(1,3)),r,c1,c2,M)
Idom.num2PEbasic.tri(c(1,2),c(1,3),rbind(c(1,2),c(1,3)),r,c1,c2,M,
ch.data.pnts = TRUE)

ind.gam2<-vector()
for (i in 1:(n-1))
  for (j in (i+1):n)
  {if (Idom.num2PEbasic.tri(Xp[i,],Xp[j,],Xp,r,c1,c2,M)==1)
   ind.gam2<-rbind(ind.gam2,c(i,j))}
ind.gam2

#or try
rv1<-rel.vert.basic.tri(Xp[1,],c1,c2,M)$rv;
rv2<-rel.vert.basic.tri(Xp[2,],c1,c2,M)$rv;
Idom.num2PEbasic.tri(Xp[1,],Xp[2,],Xp,r,c1,c2,M,rv1,rv2)

#or try
rv1<-rel.vert.basic.tri(Xp[1,],c1,c2,M)$rv;
Idom.num2PEbasic.tri(Xp[1,],Xp[2,],Xp,r,c1,c2,M,rv1)

#or try
rv2<-rel.vert.basic.tri(Xp[2,],c1,c2,M)$rv;
Idom.num2PEbasic.tri(Xp[1,],Xp[2,],Xp,r,c1,c2,M,rv2=rv2)

Idom.num2PEbasic.tri(c(1,2),Xp[2,],Xp,r,c1,c2,M,ch.data.pnts = FALSE)
#gives an error message if ch.data.pnts = TRUE since not both points are data points in Xp
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{Idom.num2PEtri}}, \code{\link{Idom.num2ASbasic.tri}},
and \code{\link{Idom.num2AStri}}
}
\author{
Elvan Ceyhan
}
