% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ArcSliceFunctions.R
\name{IarcASbasic.tri}
\alias{IarcASbasic.tri}
\title{The indicator for the presence of an arc from a point to another for Arc Slice Proximity Catch Digraphs
(AS-PCDs) - standard basic triangle case}
\usage{
IarcASbasic.tri(p1, p2, c1, c2, M = "CC", rv = NULL)
}
\arguments{
\item{p1}{A 2D point whose AS proximity region is constructed.}

\item{p2}{A 2D point. The function determines whether \code{p2} is inside the AS proximity region of
\code{p1} or not.}

\item{c1, c2}{Positive real numbers representing the top vertex in standard basic triangle \eqn{T_b=T((0,0),(1,0),(c_1,c_2))},
\eqn{c_1} must be in \eqn{[0,1/2]}, \eqn{c_2>0} and \eqn{(1-c_1)^2+c_2^2 \le 1}.}

\item{M}{The center of the triangle. \code{"CC"} stands for circumcenter or a 2D point in Cartesian coordinates or a 3D point in
barycentric coordinates which serves as a center in the interior of the triangle \eqn{T_b};
default is \code{M="CC"} i.e., the circumcenter of \eqn{T_b}.}

\item{rv}{The index of the \code{M}-vertex region in \eqn{T_b} containing the point, either \code{1,2,3} or \code{NULL}
(default is \code{NULL}).}
}
\value{
\eqn{I(p2 \in N_{AS}(p1))} for points \code{p1} and \code{p2}, that is, returns 1 if \eqn{p2} is in \eqn{N_{AS}(p1)}
(i.e., if there is an arc from \code{p1} to \code{p2}), returns 0 otherwise.
}
\description{
Returns \eqn{I(p2 \in N_{AS}(p1))} for points \code{p1} and \code{p2}, that is, returns 1 if \eqn{p2} is in \eqn{N_{AS}(p1)}, returns 0
otherwise, where \eqn{N_{AS}(x)} is the AS proximity region for point \eqn{x}.

AS proximity region is constructed in the standard basic triangle \eqn{T_b=T((0,0),(1,0),(c_1,c_2))}
where \eqn{c_1} is in \eqn{[0,1/2]}, \eqn{c_2>0} and \eqn{(1-c_1)^2+c_2^2 \le 1}.

Vertex regions are based on the center \code{M="CC"} for circumcenter of \eqn{T_b};
or \eqn{M=(m_1,m_2)} in Cartesian coordinates or \eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates in the
interior of \eqn{T_b}; default is \code{M="CC"} i.e., circumcenter of \eqn{T_b}.
\code{rv} is the index of the vertex region \code{p1} resides, with default=\code{NULL}.

If \code{p1} and \code{p2} are distinct and either of them are outside \eqn{T_b}, the function returns 0,
but if they are identical, then it returns 1 regardless of their locations (i.e., it allows loops).

Any given triangle can be mapped to the standard basic triangle
by a combination of rigid body motions (i.e., translation, rotation and reflection) and scaling,
preserving uniformity of the points in the original triangle. Hence standard basic triangle is useful for simulation
studies under the uniformity hypothesis.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:comp-geo-2010,ceyhan:mcap2012;textual}{pcds}).
}
\examples{
\dontrun{
c1<-.4; c2<-.6;
A<-c(0,0); B<-c(1,0); C<-c(c1,c2);
Tb<-rbind(A,B,C)

M<-as.numeric(runif.basic.tri(1,c1,c2)$g)  #try also M<-c(.6,.2)

P1<-as.numeric(runif.basic.tri(1,c1,c2)$g)
P2<-as.numeric(runif.basic.tri(1,c1,c2)$g)
IarcASbasic.tri(P1,P2,c1,c2,M)

P1<-c(.3,.2)
P2<-c(.6,.2)
IarcASbasic.tri(P1,P2,c1,c2,M)

#or try
Rv<-rel.vert.basic.triCC(P1,c1,c2)$rv
IarcASbasic.tri(P1,P2,c1,c2,M,Rv)

P1<-c(.3,.2)
P2<-c(.8,.2)
IarcASbasic.tri(P1,P2,c1,c2,M)

P3<-c(.5,.4)
IarcASbasic.tri(P1,P3,c1,c2,M)

P4<-c(1.5,.4)
IarcASbasic.tri(P1,P4,c1,c2,M)
IarcASbasic.tri(P4,P4,c1,c2,M)

c1<-.4; c2<-.6;
P1<-c(.3,.2)
P2<-c(.6,.2)
IarcASbasic.tri(P1,P2,c1,c2,M)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{IarcAStri}} and \code{\link{NAStri}}
}
\author{
Elvan Ceyhan
}
