% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{IndNPEend1D}
\alias{IndNPEend1D}
\title{The indicator for the presence of an arc from a point to another for
Proportional Edge Proximity Catch Digraphs (PE-PCDs) - end interval case}
\usage{
IndNPEend1D(x1, x2, r, int, rv = NULL)
}
\arguments{
\item{x1}{A 1D point whose PE proximity region is constructed.}

\item{x2}{A 1D point. The function determines whether \code{x2} is inside the PE proximity region of
\code{x1} or not.}

\item{r}{A positive real number which serves as the expansion parameter in PE proximity region;
must be \eqn{\ge 1}.}

\item{int}{A vector of two real numbers representing an interval.}

\item{rv}{Index of the end interval containing the point, either 1, 2 or \code{NULL} (default is \code{NULL}).}
}
\value{
I(\code{x2} in \eqn{NPE(x1,r)}) for points \code{x1} and \code{x2}, that is, returns 1 if \code{x2} is in \eqn{NPE(x1,r)}
(i.e., if there is an arc from \code{x1} to \code{x2}), returns 0 otherwise
}
\description{
Returns I(\code{x2} in \eqn{NPE(x1,r)}) for points \code{x1} and \code{x2}, that is, returns 1 if \code{x2} is in \eqn{NPE(x1,r)}, returns 0
otherwise, where \eqn{NPE(x,r)} is the PE proximity region for point \eqn{x} with expansion parameter \eqn{r \ge 1}
for the region outside the interval \eqn{(a,b)}.

\code{rv} is the index of the end vertex region \code{x1} resides, with default=\code{NULL},
and \eqn{rv=1} for left end interval and \eqn{rv=2} for the right end interval.
If \code{x1} and \code{x2} are distint and either of them are inside interval \code{int}, it returns 0,
but if they are identical, then it returns 1 regardless of their locations (i.e., it allows loops).

See also (\insertCite{ceyhan:metrika-2012;textual}{pcds}).
}
\examples{
a<-0; b<-10; int<-c(a,b)
r<-2

IndNPEend1D(15,17,r,int)
IndNPEend1D(15,15,r,int)

IndNPEend1D(1.5,17,r,int)

IndNPEend1D(-15,17,r,int)

IndNPEend1D(a,17,r,int)
IndNPEend1D(15,17,r=1.1,int)

a<-0; b<-10; int<-c(a,b)
r<-2
IndNPEend1D(15,17,r,int)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{IndNPEmid1D}}, \code{\link{IndNCSmid1D}}, and \code{\link{IndNCSend1D}}
}
