% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{Gam2CS.Te.onesixth}
\alias{Gam2CS.Te.onesixth}
\title{The indicator for two points constituting a dominating set for Central Similarity Proximity Catch Digraphs
(CS-PCDs) - first one sixth of the standard equilateral triangle case}
\usage{
Gam2CS.Te.onesixth(pt1, pt2, Dt, ch.data.pnts = FALSE)
}
\arguments{
\item{pt1, pt2}{Two 2D points to be tested for constituting a dominating set of the CS-PCD.}

\item{Dt}{A set of 2D points which constitutes the vertices of the CS-PCD.}

\item{ch.data.pnts}{A logical argument for checking whether points \code{pt1} and \code{pt2} are
data points in \code{Dt} or not (default is \code{FALSE}).}
}
\value{
I(\{\code{pt1,pt2}\} is a dominating set of the CS-PCD) where the vertices of the CS-PCD are the 2D data set \code{Dt}),
that is, returns 1 if \{\code{pt1,pt2}\} is a dominating set of CS-PCD, returns 0 otherwise
}
\description{
Returns I(\{\code{pt1,pt2}\} is a dominating set of the CS-PCD) where the vertices of the CS-PCD are the 2D data set \code{Dt}),
that is, returns 1 if \code{p} is a dominating point of CS-PCD, returns 0 otherwise.

CS proximity region is
constructed with respect to the standard equilateral triangle \eqn{T_e=T(A,B,C)=T((0,0),(1,0),(1/2,\sqrt{3}/2))} and
with expansion parameter \eqn{t=1}. Point, \code{pt1}, must lie in the first one-sixth of \eqn{T_e}, which is the triangle with
vertices \eqn{T(A,D_3,CM)=T((0,0),(1/2,0),CM)}.

\code{ch.data.pnts} is for checking whether points \code{pt1} and \code{pt2} are data points in \code{Dt} or not
(default is \code{FALSE}), so by default this function checks whether the points \code{pt1} and \code{pt2} would be a
dominating set if they actually were in the data set.

See also (\insertCite{ceyhan:Phd-thesis;textual}{pcds}).
}
\examples{
\dontrun{
n<-5

set.seed(1)
dat<-rbind(runifTe.onesixth(n)$gen.points,runifTe(n)$gen.points)

Gam2CS.Te.onesixth(dat[1,],dat[2,],dat)
Gam2CS.Te.onesixth(dat[1,],dat[3,],dat)
Gam2CS.Te.onesixth(c(.2,.2),dat[2,],dat)

Gam2CS.Te.onesixth(c(.2,.1),c(.3,.1),rbind(c(.2,.1),c(.3,.1)))
Gam2CS.Te.onesixth(c(1.2,1.1),c(1.3,1.1),rbind(c(1.2,1.1),c(1.3,1.1)))

n<-nrow(dat)
ind.gam2<-vector()
for (i in 1:(n-1))
 for (j in (i+1):n)
 {if (Gam2CS.Te.onesixth(dat[i,],dat[j,],dat)==1)
   ind.gam2<-rbind(ind.gam2,c(i,j))}

ind.gam2

P1<-c(.2,.1)
P2<-c(.3,.1)
Gam2CS.Te.onesixth(P1,c(.4,.2),dat)

dat.fr<-data.frame(a=dat)
Gam2CS.Te.onesixth(c(.4,.2),P2,dat.fr)

Gam2CS.Te.onesixth(c(.2,.2),dat[2,],dat,ch.data.pnts = TRUE)
#gives an error message since not both points are data points in Dt
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{Gam2CSTe}}
}
