% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{ArcsAStri}
\alias{ArcsAStri}
\title{The arcs of Arc Slice Proximity Catch Digraph (AS-PCD) for 2D data - one triangle case}
\usage{
ArcsAStri(Xp, tri, M = "CC")
}
\arguments{
\item{Xp}{A set of 2D points which constitute the vertices of the AS-PCD.}

\item{tri}{Three 2D points, stacked row-wise, each row representing a vertex of the triangle.}

\item{M}{The center of the triangle. "CC" stands for circumcenter of the triangle \code{tri} or a 2D point in Cartesian coordinates or a 3D point in
barycentric coordinates which serves as a center in the interior of the triangle \eqn{T_b};
default is \code{M}="CC" i.e. the circumcenter of \code{tri}.}
}
\value{
A list with the elements
\item{type}{A description of the type of the digraph}
\item{parameters}{Parameters of the digraph, here, it is the center used to construct the vertex regions
i.e., circumcenter}
\item{tess.points}{Points on which the tessellation of the study region is performed, here, tessellation
is the support triangle.}
\item{tess.name}{Name of data set used in tessellation (i.e., vertices of the triangle).}
\item{vertices}{Vertices of the digraph, \code{Xp}.}
\item{vert.name}{Name of the data set which constitute the vertices of the digraph}
\item{S}{Tails (or sources) of the arcs of AS-PCD for 2D data set \code{Xp} as vertices of the digraph}
\item{E}{Heads (or arrow ends) of the arcs of AS-PCD for 2D data set \code{Xp} as vertices of the digraph}
\item{mtitle}{Text for "main" title in the plot of the digraph}
\item{quant}{Various quantities for the digraph: number of vertices, number of partition points,
number of intervals, number of arcs, and arc density.}
}
\description{
An object of class "PCDs".
Returns arcs as tails (or sources) and heads (or arrow ends) for data set \code{Xp} as the vertices
of AS-PCD.

AS proximity regions are constructed with respect to the triangle \code{tri}, i.e.,
arcs may exist for points only inside \code{tri}.
It also provides various descriptions and quantities about the arcs of the AS-PCD
such as number of arcs, arc density, etc.

Vertex regions are based on the center \code{M}="CC" for
circumcenter of \code{tri}; or \eqn{M=(m_1,m_2)} in Cartesian coordinates or \eqn{M=(\alpha,\beta,\gamma)} in barycentric
coordinates in the interior of the triangle \code{tri}; default is \code{M}="CC" the circumcenter of \code{tri}.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:comp-geo-2010,ceyhan:mcap2012;textual}{pcds}).
}
\examples{
A<-c(1,1); B<-c(2,0); C<-c(1.5,2);

Tr<-rbind(A,B,C);
n<-10

set.seed(1)
dat<-runif.tri(n,Tr)$g

M<-as.numeric(runif.tri(1,Tr)$g)  #try also  #M<-c(1.6,1.2)

ArcsAStri(dat,Tr,M)

Arcs<-ArcsAStri(dat,Tr,M)
Arcs
summary(Arcs)
plot(Arcs)

S<-Arcs$S
E<-Arcs$E

Xlim<-range(Tr[,1],dat[,1])
Ylim<-range(Tr[,2],dat[,2])
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]

if (dimension(M)==3) {M<-bary2cart(M,Tr)}
#need to run this when M is given in barycentric coordinates

CC<-circ.cent.tri(Tr)
if (isTRUE(all.equal(M,CC)) || identical(M,"CC"))
{cent<-CC
D1<-(B+C)/2; D2<-(A+C)/2; D3<-(A+B)/2;
Ds<-rbind(D1,D2,D3)
cent.name<-"CC"
plot(Tr,pch=".",asp=1,xlab="",ylab="",axes=TRUE,
xlim=Xlim+xd*c(-.05,.05),ylim=Ylim+yd*c(-.05,.05))
} else
{cent<-M
cent.name<-"M"
Ds<-cp2e.tri(Tr,M)
D1<-Ds[1,]; D2<-Ds[2,]; D3<-Ds[3,]
plot(Tr,pch=".",xlab="",ylab="",axes=TRUE,
xlim=Xlim+xd*c(-.05,.05),ylim=Ylim+yd*c(-.05,.05))
}
polygon(Tr)
points(dat,pch=1,col=1)
L<-rbind(cent,cent,cent); R<-Ds
segments(L[,1], L[,2], R[,1], R[,2], lty=2)
arrows(S[,1], S[,2], E[,1], E[,2], length = 0.1, col= 4)

txt<-rbind(Tr,cent,Ds)
xc<-txt[,1]+c(-.02,.03,.02,.03,.04,-.03,-.01)
yc<-txt[,2]+c(.02,.02,.03,.06,.04,.05,-.07)
txt.str<-c("A","B","C",cent.name,"D1","D2","D3")
text(xc,yc,txt.str)

dat.fr<-data.frame(a=dat)
ArcsAStri(dat.fr,Tr,M)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{ArcsASMT}}, \code{\link{ArcsPEtri}}, \code{\link{ArcsCStri}}, \code{\link{ArcsPEMT}},
and \code{\link{ArcsCSMT}}
}
