% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{runif.tri}
\alias{runif.tri}
\title{An object of class "Uniform":

Generation of Uniform Points in a triangle}
\usage{
runif.tri(k, tri)
}
\arguments{
\item{k}{A positive integer representing the number of uniform points to be generated in the triangle}

\item{tri}{Three 2D points, stacked row-wise, each row representing a vertex of the triangle}
}
\value{
A list with the elements
\item{type}{The type of the pattern from which points are to be generated}
\item{mtitle}{The "main" title for the plot of the point pattern}
\item{tess.points}{The vertices of the support of the uniformly generated points, it is the triangle
\code{tri} for this function}
\item{gen.points}{The output set of generated points uniformly in the triangle, \code{tri}.}
\item{out.region}{The outer region which contains the support region, \code{NULL} for this function.}
\item{desc.pat}{Description of the point pattern from which points are to be generated}
\item{num.points}{The vector of two numbers, which are the number of generated points and the number
of vertices of the support points (here it is 3).}
\item{txt4pnts}{Description of the two numbers in \code{num.points}}
\item{xlimit,ylimit}{The ranges of the x- and y-coordinates of the support, \code{tri}}
}
\description{
Generates \code{k} points uniformly in a given triangle, \code{tri}
}
\examples{
n<-10  #try also n<-100
A<-c(1,1); B<-c(2,0); C<-c(1.5,2);
Tr<-rbind(A,B,C)

Xdt<-runif.tri(n,Tr)
Xdt
summary(Xdt)
plot(Xdt)

dat<-runif.tri(n,Tr)$g
Xlim<-range(Tr[,1])
Ylim<-range(Tr[,2])
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]

plot(Tr,pch=".",xlab="",ylab="",xlim=Xlim+xd*c(-.05,.05),ylim=Ylim+yd*c(-.05,.05))
polygon(Tr)
points(dat)
xc<-Tr[,1]+c(-.01,.01,.01)
yc<-Tr[,2]+c(.02,.02,.02)
txt.str<-c("A","B","C")
text(xc,yc,txt.str)

}
\seealso{
\code{\link{runifTe}}, \code{\link{runif.bastri}}, and \code{\link{runifMT}}
}
