% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{PEdomtri}
\alias{PEdomtri}
\title{The domination number of Proportional Edge Proximity Catch Digraph (PE-PCD) - one triangle case}
\usage{
PEdomtri(Xp, tri, r, M = c(1, 1, 1))
}
\arguments{
\item{Xp}{A set of 2D points which constitute the vertices of the digraph}

\item{tri}{Three 2D points, stacked row-wise, each row representing a vertex of the triangle}

\item{r}{A positive real number which serves as the expansion parameter in PE proximity region; must be \eqn{\ge 1}}

\item{M}{A 2D point in Cartesian coordinates or a 3D point in barycentric coordinates
which serves as a center in the interior of the triangle \code{tri} or the circumcenter of \code{tri},
default is (1,1,1) i.e. the center of mass}
}
\value{
A list with two elements
\item{dom.num}{Domination number of PE-PCD with vertex set=\code{Xp} and expansion parameter \eqn{r \ge 1} and center \code{M}}
\item{mds}{A minimum dominating set of PE-PCD with vertex set=\code{Xp} and expansion parameter \eqn{r \ge 1} and center \code{M}}
}
\description{
Returns the domination number of PE-PCD whose vertices are the data points in \code{Xp}.

PE proximity region is defined with respect to the triangle \code{tri} with expansion parameter \eqn{r \ge 1} and
vertex regions are constructed with center \eqn{M=(m_1,m_2)} in Cartesian coordinates or \eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates
in the interior of the triangle \code{tri} or the circumcenter of \code{tri}.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:masa-2007,ceyhan:dom-num-NPE-Spat2011,ceyhan:mcap2012;textual}{pcds}).
}
\examples{
A<-c(0,0); B<-c(1,0); C<-c(1/2,sqrt(3)/2)
Tr<-rbind(A,B,C)
n<-10  #try also n<-20
dat<-runif.tri(n,Tr)$g

M<-as.numeric(runif.tri(1,Tr)$g)  #try also M<-c(1,1,1)

r<-1.4

PEdomtri(dat,Tr,r,M)
IM<-IncMatPEtri(dat,Tr,r,M)
dom.greedy(IM)
dom.exact(IM)

gr.gam<-dom.greedy(IM)
gr.gam
dat[gr.gam$i,]

PEdomtri(rbind(dat,c(5,5)),Tr,r,M)

PEdomtri(dat,Tr,r,M=c(.4,.4))

PEdomtri(rbind(dat,c(5,5)),Tr,r,M=c(.4,.4))

P1<-c(.5,.5)
PEdomtri(P1,Tr,r,M)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{PEdomMTnd}}, \code{\link{PEdomMT}} and \code{\link{PEdom1D}}
}
